# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from inductiva.client.models.machine_group_costs import MachineGroupCosts
from inductiva.client.models.machine_group_status import MachineGroupStatus
from inductiva.client.models.machine_group_type import MachineGroupType
from inductiva.client.models.machine_group_usage_statistics import MachineGroupUsageStatistics
from inductiva.client.models.providers import Providers
from typing import Optional, Set
from typing_extensions import Self


class MachineGroupWithCosts(BaseModel):
    """
    MachineGroupWithCosts
    """

  # noqa: E501
    id: StrictStr
    name: StrictStr
    machine_type: StrictStr
    disk_size_gb: StrictInt
    auto_resize_disk_max_gb: Optional[StrictInt] = None
    num_vms: StrictInt
    min_vms: Optional[StrictInt] = None
    max_vms: Optional[StrictInt] = None
    spot: StrictBool
    type: MachineGroupType
    creation_timestamp: datetime
    start_timestamp: Optional[datetime]
    deletion_timestamp: Optional[datetime]
    provider_id: Providers
    provider_description: Optional[StrictStr] = None
    status: MachineGroupStatus
    threads_per_core: StrictInt
    max_idle_time: Optional[Union[StrictFloat, StrictInt]]
    termination_reason: Optional[StrictStr] = None
    statistics: MachineGroupUsageStatistics
    idle_time_seconds: Optional[StrictInt] = None
    costs: MachineGroupCosts
    __properties: ClassVar[List[str]] = [
        "id", "name", "machine_type", "disk_size_gb", "auto_resize_disk_max_gb",
        "num_vms", "min_vms", "max_vms", "spot", "type", "creation_timestamp",
        "start_timestamp", "deletion_timestamp", "provider_id",
        "provider_description", "status", "threads_per_core", "max_idle_time",
        "termination_reason", "statistics", "idle_time_seconds", "costs"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MachineGroupWithCosts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of costs
        if self.costs:
            _dict['costs'] = self.costs.to_dict()
        # set to None if auto_resize_disk_max_gb (nullable) is None
        # and model_fields_set contains the field
        if self.auto_resize_disk_max_gb is None and "auto_resize_disk_max_gb" in self.model_fields_set:
            _dict['auto_resize_disk_max_gb'] = None

        # set to None if min_vms (nullable) is None
        # and model_fields_set contains the field
        if self.min_vms is None and "min_vms" in self.model_fields_set:
            _dict['min_vms'] = None

        # set to None if max_vms (nullable) is None
        # and model_fields_set contains the field
        if self.max_vms is None and "max_vms" in self.model_fields_set:
            _dict['max_vms'] = None

        # set to None if start_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.start_timestamp is None and "start_timestamp" in self.model_fields_set:
            _dict['start_timestamp'] = None

        # set to None if deletion_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.deletion_timestamp is None and "deletion_timestamp" in self.model_fields_set:
            _dict['deletion_timestamp'] = None

        # set to None if provider_description (nullable) is None
        # and model_fields_set contains the field
        if self.provider_description is None and "provider_description" in self.model_fields_set:
            _dict['provider_description'] = None

        # set to None if max_idle_time (nullable) is None
        # and model_fields_set contains the field
        if self.max_idle_time is None and "max_idle_time" in self.model_fields_set:
            _dict['max_idle_time'] = None

        # set to None if termination_reason (nullable) is None
        # and model_fields_set contains the field
        if self.termination_reason is None and "termination_reason" in self.model_fields_set:
            _dict['termination_reason'] = None

        # set to None if idle_time_seconds (nullable) is None
        # and model_fields_set contains the field
        if self.idle_time_seconds is None and "idle_time_seconds" in self.model_fields_set:
            _dict['idle_time_seconds'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MachineGroupWithCosts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id":
                obj.get("id"),
            "name":
                obj.get("name"),
            "machine_type":
                obj.get("machine_type"),
            "disk_size_gb":
                obj.get("disk_size_gb"),
            "auto_resize_disk_max_gb":
                obj.get("auto_resize_disk_max_gb"),
            "num_vms":
                obj.get("num_vms"),
            "min_vms":
                obj.get("min_vms"),
            "max_vms":
                obj.get("max_vms"),
            "spot":
                obj.get("spot"),
            "type":
                obj.get("type"),
            "creation_timestamp":
                obj.get("creation_timestamp"),
            "start_timestamp":
                obj.get("start_timestamp"),
            "deletion_timestamp":
                obj.get("deletion_timestamp"),
            "provider_id":
                obj.get("provider_id"),
            "provider_description":
                obj.get("provider_description"),
            "status":
                obj.get("status"),
            "threads_per_core":
                obj.get("threads_per_core"),
            "max_idle_time":
                obj.get("max_idle_time"),
            "termination_reason":
                obj.get("termination_reason"),
            "statistics":
                MachineGroupUsageStatistics.from_dict(obj["statistics"])
                if obj.get("statistics") is not None else None,
            "idle_time_seconds":
                obj.get("idle_time_seconds"),
            "costs":
                MachineGroupCosts.from_dict(obj["costs"])
                if obj.get("costs") is not None else None
        })
        return _obj
