# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from inductiva.client.models.last_preemption import LastPreemption
from typing import Optional, Set
from typing_extensions import Self


class MachinePreemptionStatistics(BaseModel):
    """
    MachinePreemptionStatistics
    """

  # noqa: E501
    machine_series: StrictStr
    machines_count: StrictInt
    preemption_count: StrictInt
    preemption_rate_percentage: Optional[Union[StrictFloat, StrictInt]] = None
    vcpus_count: StrictInt
    vcpus_preemption_count: StrictInt
    vcpus_preemption_rate_percentage: Optional[Union[StrictFloat,
                                                     StrictInt]] = None
    last_preemption: LastPreemption
    __properties: ClassVar[List[str]] = [
        "machine_series", "machines_count", "preemption_count",
        "preemption_rate_percentage", "vcpus_count", "vcpus_preemption_count",
        "vcpus_preemption_rate_percentage", "last_preemption"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MachinePreemptionStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_preemption
        if self.last_preemption:
            _dict['last_preemption'] = self.last_preemption.to_dict()
        # set to None if preemption_rate_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.preemption_rate_percentage is None and "preemption_rate_percentage" in self.model_fields_set:
            _dict['preemption_rate_percentage'] = None

        # set to None if vcpus_preemption_rate_percentage (nullable) is None
        # and model_fields_set contains the field
        if self.vcpus_preemption_rate_percentage is None and "vcpus_preemption_rate_percentage" in self.model_fields_set:
            _dict['vcpus_preemption_rate_percentage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MachinePreemptionStatistics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "machine_series":
                obj.get("machine_series"),
            "machines_count":
                obj.get("machines_count"),
            "preemption_count":
                obj.get("preemption_count"),
            "preemption_rate_percentage":
                obj.get("preemption_rate_percentage"),
            "vcpus_count":
                obj.get("vcpus_count"),
            "vcpus_preemption_count":
                obj.get("vcpus_preemption_count"),
            "vcpus_preemption_rate_percentage":
                obj.get("vcpus_preemption_rate_percentage"),
            "last_preemption":
                LastPreemption.from_dict(obj["last_preemption"])
                if obj.get("last_preemption") is not None else None
        })
        return _obj
