# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from inductiva.client.models.upload_part import UploadPart
from typing import Optional, Set
from typing_extensions import Self


class MultiPartExportOperation(BaseModel):
    """
    Body of the request to the multipart export files endpoint.
    """ # noqa: E501
    path: StrictStr
    parts_size: StrictInt
    upload_parts: List[UploadPart]
    complete_multipart_url: Annotated[str, Field(min_length=1, strict=True)]
    __properties: ClassVar[List[str]] = [
        "path", "parts_size", "upload_parts", "complete_multipart_url"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MultiPartExportOperation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in upload_parts (list)
        _items = []
        if self.upload_parts:
            for _item_upload_parts in self.upload_parts:
                if _item_upload_parts:
                    _items.append(_item_upload_parts.to_dict())
            _dict['upload_parts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MultiPartExportOperation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "path":
                obj.get("path"),
            "parts_size":
                obj.get("parts_size"),
            "upload_parts": [
                UploadPart.from_dict(_item) for _item in obj["upload_parts"]
            ] if obj.get("upload_parts") is not None else None,
            "complete_multipart_url":
                obj.get("complete_multipart_url")
        })
        return _obj
