# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from inductiva.client.models.currency_code import CurrencyCode
from inductiva.client.models.organization_cost_components import OrganizationCostComponents
from inductiva.client.models.user_costs_details import UserCostsDetails
from typing import Optional, Set
from typing_extensions import Self


class OrganizationCosts(BaseModel):
    """
    OrganizationCosts
    """

  # noqa: E501
    id: StrictStr
    name: StrictStr
    tier_id: StrictStr
    currency: Optional[CurrencyCode] = None
    consolidation_last_update_ts: Optional[datetime]
    costs: OrganizationCostComponents
    estimated_costs: List[UserCostsDetails]
    __properties: ClassVar[List[str]] = [
        "id", "name", "tier_id", "currency", "consolidation_last_update_ts",
        "costs", "estimated_costs"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationCosts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of costs
        if self.costs:
            _dict['costs'] = self.costs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in estimated_costs (list)
        _items = []
        if self.estimated_costs:
            for _item_estimated_costs in self.estimated_costs:
                if _item_estimated_costs:
                    _items.append(_item_estimated_costs.to_dict())
            _dict['estimated_costs'] = _items
        # set to None if consolidation_last_update_ts (nullable) is None
        # and model_fields_set contains the field
        if self.consolidation_last_update_ts is None and "consolidation_last_update_ts" in self.model_fields_set:
            _dict['consolidation_last_update_ts'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationCosts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id":
                obj.get("id"),
            "name":
                obj.get("name"),
            "tier_id":
                obj.get("tier_id"),
            "currency":
                obj.get("currency"),
            "consolidation_last_update_ts":
                obj.get("consolidation_last_update_ts"),
            "costs":
                OrganizationCostComponents.from_dict(obj["costs"])
                if obj.get("costs") is not None else None,
            "estimated_costs": [
                UserCostsDetails.from_dict(_item)
                for _item in obj["estimated_costs"]
            ] if obj.get("estimated_costs") is not None else None
        })
        return _obj
