# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from inductiva.client.models.orchestration_fee import OrchestrationFee
from inductiva.client.models.task_position_in_queue import TaskPositionInQueue
from inductiva.client.models.task_status_code import TaskStatusCode
from typing import Optional, Set
from typing_extensions import Self


class TaskSubmittedInfo(BaseModel):
    """
    TaskSubmittedInfo
    """

  # noqa: E501
    id: StrictStr
    status: TaskStatusCode
    position_in_queue: Optional[TaskPositionInQueue] = None
    is_terminated: StrictBool
    storage_region: Optional[StrictStr] = None
    time_to_live_seconds: Optional[Union[StrictFloat, StrictInt]] = None
    orchestration_fee: Optional[OrchestrationFee] = None
    __properties: ClassVar[List[str]] = [
        "id", "status", "position_in_queue", "is_terminated", "storage_region",
        "time_to_live_seconds", "orchestration_fee"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskSubmittedInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position_in_queue
        if self.position_in_queue:
            _dict['position_in_queue'] = self.position_in_queue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of orchestration_fee
        if self.orchestration_fee:
            _dict['orchestration_fee'] = self.orchestration_fee.to_dict()
        # set to None if position_in_queue (nullable) is None
        # and model_fields_set contains the field
        if self.position_in_queue is None and "position_in_queue" in self.model_fields_set:
            _dict['position_in_queue'] = None

        # set to None if storage_region (nullable) is None
        # and model_fields_set contains the field
        if self.storage_region is None and "storage_region" in self.model_fields_set:
            _dict['storage_region'] = None

        # set to None if time_to_live_seconds (nullable) is None
        # and model_fields_set contains the field
        if self.time_to_live_seconds is None and "time_to_live_seconds" in self.model_fields_set:
            _dict['time_to_live_seconds'] = None

        # set to None if orchestration_fee (nullable) is None
        # and model_fields_set contains the field
        if self.orchestration_fee is None and "orchestration_fee" in self.model_fields_set:
            _dict['orchestration_fee'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskSubmittedInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id":
                obj.get("id"),
            "status":
                obj.get("status"),
            "position_in_queue":
                TaskPositionInQueue.from_dict(obj["position_in_queue"])
                if obj.get("position_in_queue") is not None else None,
            "is_terminated":
                obj.get("is_terminated"),
            "storage_region":
                obj.get("storage_region"),
            "time_to_live_seconds":
                obj.get("time_to_live_seconds"),
            "orchestration_fee":
                OrchestrationFee.from_dict(obj["orchestration_fee"])
                if obj.get("orchestration_fee") is not None else None
        })
        return _obj
