# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from inductiva.client.models.team_role import TeamRole
from typing import Optional, Set
from typing_extensions import Self


class TeamMemberResponse(BaseModel):
    """
    Schema for team member response.
    """

  # noqa: E501
    role: TeamRole
    id: StrictStr
    organization_id: StrictStr
    joined_at: datetime
    last_activity_at: Optional[datetime] = None
    is_active: StrictBool
    user_email: StrictStr
    user_name: Optional[StrictStr] = None
    user_username: StrictStr
    invited_by_email: Optional[StrictStr] = None
    invited_by_name: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = [
        "role", "id", "organization_id", "joined_at", "last_activity_at",
        "is_active", "user_email", "user_name", "user_username",
        "invited_by_email", "invited_by_name"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TeamMemberResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if last_activity_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_activity_at is None and "last_activity_at" in self.model_fields_set:
            _dict['last_activity_at'] = None

        # set to None if user_name (nullable) is None
        # and model_fields_set contains the field
        if self.user_name is None and "user_name" in self.model_fields_set:
            _dict['user_name'] = None

        # set to None if invited_by_email (nullable) is None
        # and model_fields_set contains the field
        if self.invited_by_email is None and "invited_by_email" in self.model_fields_set:
            _dict['invited_by_email'] = None

        # set to None if invited_by_name (nullable) is None
        # and model_fields_set contains the field
        if self.invited_by_name is None and "invited_by_name" in self.model_fields_set:
            _dict['invited_by_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TeamMemberResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "role": obj.get("role"),
            "id": obj.get("id"),
            "organization_id": obj.get("organization_id"),
            "joined_at": obj.get("joined_at"),
            "last_activity_at": obj.get("last_activity_at"),
            "is_active": obj.get("is_active"),
            "user_email": obj.get("user_email"),
            "user_name": obj.get("user_name"),
            "user_username": obj.get("user_username"),
            "invited_by_email": obj.get("invited_by_email"),
            "invited_by_name": obj.get("invited_by_name")
        })
        return _obj
