# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from inductiva.client.models.currency_code import CurrencyCode
from inductiva.client.models.terms_and_conditions import TermsAndConditions
from typing import Optional, Set
from typing_extensions import Self


class User(BaseModel):
    """
    User
    """

  # noqa: E501
    email: StrictStr
    username: StrictStr
    name: Optional[StrictStr] = None
    organization: Optional[StrictStr] = None
    tier: StrictStr
    total_available_credits: Union[StrictFloat, StrictInt]
    credits_currency: Optional[CurrencyCode] = None
    terms_and_conditions_decision: TermsAndConditions
    terms_and_conditions_decision_ts: Optional[datetime] = None
    extra_metadata: Optional[Dict[str, StrictStr]] = None
    registration_ts: datetime
    costs_fee_percentage: Union[StrictFloat, StrictInt]
    terminate_resources_credits_threshold: Union[StrictFloat, StrictInt]
    __properties: ClassVar[List[str]] = [
        "email", "username", "name", "organization", "tier",
        "total_available_credits", "credits_currency",
        "terms_and_conditions_decision", "terms_and_conditions_decision_ts",
        "extra_metadata", "registration_ts", "costs_fee_percentage",
        "terminate_resources_credits_threshold"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of User from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if organization (nullable) is None
        # and model_fields_set contains the field
        if self.organization is None and "organization" in self.model_fields_set:
            _dict['organization'] = None

        # set to None if terms_and_conditions_decision_ts (nullable) is None
        # and model_fields_set contains the field
        if self.terms_and_conditions_decision_ts is None and "terms_and_conditions_decision_ts" in self.model_fields_set:
            _dict['terms_and_conditions_decision_ts'] = None

        # set to None if extra_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.extra_metadata is None and "extra_metadata" in self.model_fields_set:
            _dict['extra_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of User from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "email":
                obj.get("email"),
            "username":
                obj.get("username"),
            "name":
                obj.get("name"),
            "organization":
                obj.get("organization"),
            "tier":
                obj.get("tier"),
            "total_available_credits":
                obj.get("total_available_credits"),
            "credits_currency":
                obj.get("credits_currency"),
            "terms_and_conditions_decision":
                obj.get("terms_and_conditions_decision"),
            "terms_and_conditions_decision_ts":
                obj.get("terms_and_conditions_decision_ts"),
            "extra_metadata":
                obj.get("extra_metadata"),
            "registration_ts":
                obj.get("registration_ts"),
            "costs_fee_percentage":
                obj.get("costs_fee_percentage"),
            "terminate_resources_credits_threshold":
                obj.get("terminate_resources_credits_threshold")
        })
        return _obj
