# coding: utf-8

"""
    InductivaWebAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from inductiva.client.models.autoscale_policy import AutoscalePolicy
from inductiva.client.models.cpu_info import CPUInfo
from inductiva.client.models.dynamic_disk_resize_config import DynamicDiskResizeConfig
from inductiva.client.models.gpu_info import GPUInfo
from inductiva.client.models.machine_group_cost_per_hour import MachineGroupCostPerHour
from inductiva.client.models.machine_group_costs import MachineGroupCosts
from inductiva.client.models.machine_group_status import MachineGroupStatus
from inductiva.client.models.machine_group_type import MachineGroupType
from inductiva.client.models.machine_group_usage_statistics import MachineGroupUsageStatistics
from inductiva.client.models.machine_info import MachineInfo
from inductiva.client.models.providers import Providers
from inductiva.client.models.sharing_level import SharingLevel
from typing import Optional, Set
from typing_extensions import Self


class VMGroupConfig(BaseModel):
    """
    Schema for creating an instance group.
    """

  # noqa: E501
    max_idle_time: Optional[Union[StrictFloat, StrictInt]] = None
    auto_terminate_ts: Optional[datetime] = None
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    machine_type: Optional[StrictStr] = None
    disk_size_gb: Optional[StrictInt] = None
    total_ram_gb: Optional[StrictInt] = None
    threads_per_core: Optional[StrictInt] = None
    num_vms: Optional[StrictInt] = None
    idle_seconds: Optional[StrictInt] = None
    creation_timestamp: Optional[datetime] = None
    deletion_timestamp: Optional[datetime] = None
    type: Optional[MachineGroupType] = None
    provider_id: Optional[Providers] = None
    started: Optional[StrictBool] = False
    quota_usage: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = None
    status: Optional[MachineGroupStatus] = None
    spot: Optional[StrictBool] = False
    is_elastic: Optional[StrictBool] = False
    min_vms: Optional[StrictInt] = None
    max_vms: Optional[StrictInt] = None
    autoscale_policy: Optional[AutoscalePolicy] = None
    dynamic_disk_resize_config: Optional[DynamicDiskResizeConfig] = None
    custom_vm_image: Optional[StrictStr] = None
    machines: Optional[List[MachineInfo]] = None
    provider_description: Optional[StrictStr] = None
    costs: Optional[MachineGroupCosts] = None
    cost_per_hour: Optional[MachineGroupCostPerHour] = None
    statistics: Optional[MachineGroupUsageStatistics] = None
    sharing_level: Optional[SharingLevel] = None
    zone: StrictStr
    gpu_info: Optional[GPUInfo] = None
    cpu_info: Optional[CPUInfo] = None
    __properties: ClassVar[List[str]] = [
        "max_idle_time", "auto_terminate_ts", "id", "name", "machine_type",
        "disk_size_gb", "total_ram_gb", "threads_per_core", "num_vms",
        "idle_seconds", "creation_timestamp", "deletion_timestamp", "type",
        "provider_id", "started", "quota_usage", "status", "spot", "is_elastic",
        "min_vms", "max_vms", "autoscale_policy", "dynamic_disk_resize_config",
        "custom_vm_image", "machines", "provider_description", "costs",
        "cost_per_hour", "statistics", "sharing_level", "zone", "gpu_info",
        "cpu_info"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VMGroupConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dynamic_disk_resize_config
        if self.dynamic_disk_resize_config:
            _dict[
                'dynamic_disk_resize_config'] = self.dynamic_disk_resize_config.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of each item in machines (list)
        _items = []
        if self.machines:
            for _item_machines in self.machines:
                if _item_machines:
                    _items.append(_item_machines.to_dict())
            _dict['machines'] = _items
        # override the default output from pydantic by calling `to_dict()` of costs
        if self.costs:
            _dict['costs'] = self.costs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_per_hour
        if self.cost_per_hour:
            _dict['cost_per_hour'] = self.cost_per_hour.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gpu_info
        if self.gpu_info:
            _dict['gpu_info'] = self.gpu_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu_info
        if self.cpu_info:
            _dict['cpu_info'] = self.cpu_info.to_dict()
        # set to None if max_idle_time (nullable) is None
        # and model_fields_set contains the field
        if self.max_idle_time is None and "max_idle_time" in self.model_fields_set:
            _dict['max_idle_time'] = None

        # set to None if auto_terminate_ts (nullable) is None
        # and model_fields_set contains the field
        if self.auto_terminate_ts is None and "auto_terminate_ts" in self.model_fields_set:
            _dict['auto_terminate_ts'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if machine_type (nullable) is None
        # and model_fields_set contains the field
        if self.machine_type is None and "machine_type" in self.model_fields_set:
            _dict['machine_type'] = None

        # set to None if disk_size_gb (nullable) is None
        # and model_fields_set contains the field
        if self.disk_size_gb is None and "disk_size_gb" in self.model_fields_set:
            _dict['disk_size_gb'] = None

        # set to None if total_ram_gb (nullable) is None
        # and model_fields_set contains the field
        if self.total_ram_gb is None and "total_ram_gb" in self.model_fields_set:
            _dict['total_ram_gb'] = None

        # set to None if threads_per_core (nullable) is None
        # and model_fields_set contains the field
        if self.threads_per_core is None and "threads_per_core" in self.model_fields_set:
            _dict['threads_per_core'] = None

        # set to None if num_vms (nullable) is None
        # and model_fields_set contains the field
        if self.num_vms is None and "num_vms" in self.model_fields_set:
            _dict['num_vms'] = None

        # set to None if idle_seconds (nullable) is None
        # and model_fields_set contains the field
        if self.idle_seconds is None and "idle_seconds" in self.model_fields_set:
            _dict['idle_seconds'] = None

        # set to None if creation_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.creation_timestamp is None and "creation_timestamp" in self.model_fields_set:
            _dict['creation_timestamp'] = None

        # set to None if deletion_timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.deletion_timestamp is None and "deletion_timestamp" in self.model_fields_set:
            _dict['deletion_timestamp'] = None

        # set to None if quota_usage (nullable) is None
        # and model_fields_set contains the field
        if self.quota_usage is None and "quota_usage" in self.model_fields_set:
            _dict['quota_usage'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if min_vms (nullable) is None
        # and model_fields_set contains the field
        if self.min_vms is None and "min_vms" in self.model_fields_set:
            _dict['min_vms'] = None

        # set to None if max_vms (nullable) is None
        # and model_fields_set contains the field
        if self.max_vms is None and "max_vms" in self.model_fields_set:
            _dict['max_vms'] = None

        # set to None if dynamic_disk_resize_config (nullable) is None
        # and model_fields_set contains the field
        if self.dynamic_disk_resize_config is None and "dynamic_disk_resize_config" in self.model_fields_set:
            _dict['dynamic_disk_resize_config'] = None

        # set to None if custom_vm_image (nullable) is None
        # and model_fields_set contains the field
        if self.custom_vm_image is None and "custom_vm_image" in self.model_fields_set:
            _dict['custom_vm_image'] = None

        # set to None if provider_description (nullable) is None
        # and model_fields_set contains the field
        if self.provider_description is None and "provider_description" in self.model_fields_set:
            _dict['provider_description'] = None

        # set to None if costs (nullable) is None
        # and model_fields_set contains the field
        if self.costs is None and "costs" in self.model_fields_set:
            _dict['costs'] = None

        # set to None if cost_per_hour (nullable) is None
        # and model_fields_set contains the field
        if self.cost_per_hour is None and "cost_per_hour" in self.model_fields_set:
            _dict['cost_per_hour'] = None

        # set to None if statistics (nullable) is None
        # and model_fields_set contains the field
        if self.statistics is None and "statistics" in self.model_fields_set:
            _dict['statistics'] = None

        # set to None if sharing_level (nullable) is None
        # and model_fields_set contains the field
        if self.sharing_level is None and "sharing_level" in self.model_fields_set:
            _dict['sharing_level'] = None

        # set to None if gpu_info (nullable) is None
        # and model_fields_set contains the field
        if self.gpu_info is None and "gpu_info" in self.model_fields_set:
            _dict['gpu_info'] = None

        # set to None if cpu_info (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_info is None and "cpu_info" in self.model_fields_set:
            _dict['cpu_info'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VMGroupConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "max_idle_time":
                obj.get("max_idle_time"),
            "auto_terminate_ts":
                obj.get("auto_terminate_ts"),
            "id":
                obj.get("id"),
            "name":
                obj.get("name"),
            "machine_type":
                obj.get("machine_type"),
            "disk_size_gb":
                obj.get("disk_size_gb"),
            "total_ram_gb":
                obj.get("total_ram_gb"),
            "threads_per_core":
                obj.get("threads_per_core"),
            "num_vms":
                obj.get("num_vms"),
            "idle_seconds":
                obj.get("idle_seconds"),
            "creation_timestamp":
                obj.get("creation_timestamp"),
            "deletion_timestamp":
                obj.get("deletion_timestamp"),
            "type":
                obj.get("type"),
            "provider_id":
                obj.get("provider_id"),
            "started":
                obj.get("started") if obj.get("started") is not None else False,
            "quota_usage":
                obj.get("quota_usage"),
            "status":
                obj.get("status"),
            "spot":
                obj.get("spot") if obj.get("spot") is not None else False,
            "is_elastic":
                obj.get("is_elastic")
                if obj.get("is_elastic") is not None else False,
            "min_vms":
                obj.get("min_vms"),
            "max_vms":
                obj.get("max_vms"),
            "autoscale_policy":
                obj.get("autoscale_policy"),
            "dynamic_disk_resize_config":
                DynamicDiskResizeConfig.from_dict(
                    obj["dynamic_disk_resize_config"])
                if obj.get("dynamic_disk_resize_config") is not None else None,
            "custom_vm_image":
                obj.get("custom_vm_image"),
            "machines": [
                MachineInfo.from_dict(_item) for _item in obj["machines"]
            ] if obj.get("machines") is not None else None,
            "provider_description":
                obj.get("provider_description"),
            "costs":
                MachineGroupCosts.from_dict(obj["costs"])
                if obj.get("costs") is not None else None,
            "cost_per_hour":
                MachineGroupCostPerHour.from_dict(obj["cost_per_hour"])
                if obj.get("cost_per_hour") is not None else None,
            "statistics":
                MachineGroupUsageStatistics.from_dict(obj["statistics"])
                if obj.get("statistics") is not None else None,
            "sharing_level":
                obj.get("sharing_level"),
            "zone":
                obj.get("zone"),
            "gpu_info":
                GPUInfo.from_dict(obj["gpu_info"])
                if obj.get("gpu_info") is not None else None,
            "cpu_info":
                CPUInfo.from_dict(obj["cpu_info"])
                if obj.get("cpu_info") is not None else None
        })
        return _obj
