# coding: utf-8

"""
    Machine Catalogue

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictFloat, StrictInt, StrictStr
from typing import Any, List, Optional, Union
from typing_extensions import Annotated
from inductiva.machines_catalogue_client.models.machine_type import MachineType
from inductiva.machines_catalogue_client.models.providers import Providers

from inductiva.machines_catalogue_client.api_client import ApiClient, RequestSerialized
from inductiva.machines_catalogue_client.api_response import ApiResponse
from inductiva.machines_catalogue_client.rest import RESTResponseType


class PricingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_disk_price_pricing_disk_get(
        self,
        region: StrictStr,
        disk_type: StrictStr,
        disk_size_gb: StrictInt,
        provider_id: Providers,
        provisioned_iops: Optional[StrictInt] = None,
        provisioned_throughput: Optional[StrictInt] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Get Disk Price


        :param region: (required)
        :type region: str
        :param disk_type: (required)
        :type disk_type: str
        :param disk_size_gb: (required)
        :type disk_size_gb: int
        :param provider_id: (required)
        :type provider_id: Providers
        :param provisioned_iops:
        :type provisioned_iops: int
        :param provisioned_throughput:
        :type provisioned_throughput: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_disk_price_pricing_disk_get_serialize(
            region=region,
            disk_type=disk_type,
            disk_size_gb=disk_size_gb,
            provider_id=provider_id,
            provisioned_iops=provisioned_iops,
            provisioned_throughput=provisioned_throughput,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_disk_price_pricing_disk_get_with_http_info(
        self,
        region: StrictStr,
        disk_type: StrictStr,
        disk_size_gb: StrictInt,
        provider_id: Providers,
        provisioned_iops: Optional[StrictInt] = None,
        provisioned_throughput: Optional[StrictInt] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Get Disk Price


        :param region: (required)
        :type region: str
        :param disk_type: (required)
        :type disk_type: str
        :param disk_size_gb: (required)
        :type disk_size_gb: int
        :param provider_id: (required)
        :type provider_id: Providers
        :param provisioned_iops:
        :type provisioned_iops: int
        :param provisioned_throughput:
        :type provisioned_throughput: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_disk_price_pricing_disk_get_serialize(
            region=region,
            disk_type=disk_type,
            disk_size_gb=disk_size_gb,
            provider_id=provider_id,
            provisioned_iops=provisioned_iops,
            provisioned_throughput=provisioned_throughput,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_disk_price_pricing_disk_get_without_preload_content(
        self,
        region: StrictStr,
        disk_type: StrictStr,
        disk_size_gb: StrictInt,
        provider_id: Providers,
        provisioned_iops: Optional[StrictInt] = None,
        provisioned_throughput: Optional[StrictInt] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Disk Price


        :param region: (required)
        :type region: str
        :param disk_type: (required)
        :type disk_type: str
        :param disk_size_gb: (required)
        :type disk_size_gb: int
        :param provider_id: (required)
        :type provider_id: Providers
        :param provisioned_iops:
        :type provisioned_iops: int
        :param provisioned_throughput:
        :type provisioned_throughput: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_disk_price_pricing_disk_get_serialize(
            region=region,
            disk_type=disk_type,
            disk_size_gb=disk_size_gb,
            provider_id=provider_id,
            provisioned_iops=provisioned_iops,
            provisioned_throughput=provisioned_throughput,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_disk_price_pricing_disk_get_serialize(
        self,
        region,
        disk_type,
        disk_size_gb,
        provider_id,
        provisioned_iops,
        provisioned_throughput,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if region is not None:

            _query_params.append(('region', region))

        if disk_type is not None:

            _query_params.append(('disk_type', disk_type))

        if disk_size_gb is not None:

            _query_params.append(('disk_size_gb', disk_size_gb))

        if provisioned_iops is not None:

            _query_params.append(('provisioned_iops', provisioned_iops))

        if provisioned_throughput is not None:

            _query_params.append(
                ('provisioned_throughput', provisioned_throughput))

        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pricing/disk',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def get_machine_type_pricing_machine_types_machine_type_get(
        self,
        machine_type: StrictStr,
        zone: StrictStr,
        spot: StrictStr,
        provider_id: Providers,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Hello World


        :param machine_type: (required)
        :type machine_type: str
        :param zone: (required)
        :type zone: str
        :param spot: (required)
        :type spot: str
        :param provider_id: (required)
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_machine_type_pricing_machine_types_machine_type_get_serialize(
            machine_type=machine_type,
            zone=zone,
            spot=spot,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_machine_type_pricing_machine_types_machine_type_get_with_http_info(
        self,
        machine_type: StrictStr,
        zone: StrictStr,
        spot: StrictStr,
        provider_id: Providers,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Hello World


        :param machine_type: (required)
        :type machine_type: str
        :param zone: (required)
        :type zone: str
        :param spot: (required)
        :type spot: str
        :param provider_id: (required)
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_machine_type_pricing_machine_types_machine_type_get_serialize(
            machine_type=machine_type,
            zone=zone,
            spot=spot,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_machine_type_pricing_machine_types_machine_type_get_without_preload_content(
        self,
        machine_type: StrictStr,
        zone: StrictStr,
        spot: StrictStr,
        provider_id: Providers,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Hello World


        :param machine_type: (required)
        :type machine_type: str
        :param zone: (required)
        :type zone: str
        :param spot: (required)
        :type spot: str
        :param provider_id: (required)
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_machine_type_pricing_machine_types_machine_type_get_serialize(
            machine_type=machine_type,
            zone=zone,
            spot=spot,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_machine_type_pricing_machine_types_machine_type_get_serialize(
        self,
        machine_type,
        zone,
        spot,
        provider_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if machine_type is not None:
            _path_params['machine_type'] = machine_type
        # process the query parameters
        if zone is not None:

            _query_params.append(('zone', zone))

        if spot is not None:

            _query_params.append(('spot', spot))

        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pricing/machine-types/{machine_type}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def get_storage_price_pricing_storage_get(
        self,
        region: StrictStr,
        provider_id: Providers,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Get Storage Price


        :param region: (required)
        :type region: str
        :param provider_id: (required)
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_storage_price_pricing_storage_get_serialize(
            region=region,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_storage_price_pricing_storage_get_with_http_info(
        self,
        region: StrictStr,
        provider_id: Providers,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Get Storage Price


        :param region: (required)
        :type region: str
        :param provider_id: (required)
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_storage_price_pricing_storage_get_serialize(
            region=region,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_storage_price_pricing_storage_get_without_preload_content(
        self,
        region: StrictStr,
        provider_id: Providers,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Storage Price


        :param region: (required)
        :type region: str
        :param provider_id: (required)
        :type provider_id: Providers
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_storage_price_pricing_storage_get_serialize(
            region=region,
            provider_id=provider_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _get_storage_price_pricing_storage_get_serialize(
        self,
        region,
        provider_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if region is not None:

            _query_params.append(('region', region))

        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pricing/storage',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def list_available_machine_types_pricing_machine_types_get(
        self,
        provider_id: Providers,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        spot: Optional[Any] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[MachineType]:
        """List Available Machine Types

        List available machine types for the given provider and zone.

        :param provider_id: (required)
        :type provider_id: Providers
        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param spot:
        :type spot: Spot
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_available_machine_types_pricing_machine_types_get_serialize(
            provider_id=provider_id,
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            spot=spot,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MachineType]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_available_machine_types_pricing_machine_types_get_with_http_info(
        self,
        provider_id: Providers,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        spot: Optional[Any] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[MachineType]]:
        """List Available Machine Types

        List available machine types for the given provider and zone.

        :param provider_id: (required)
        :type provider_id: Providers
        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param spot:
        :type spot: Spot
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_available_machine_types_pricing_machine_types_get_serialize(
            provider_id=provider_id,
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            spot=spot,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MachineType]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_available_machine_types_pricing_machine_types_get_without_preload_content(
        self,
        provider_id: Providers,
        machine_families: Optional[List[StrictStr]] = None,
        machine_configs: Optional[List[StrictStr]] = None,
        vcpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        memory_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        price_range: Optional[Annotated[
            List[Union[StrictFloat, StrictInt]],
            Field(min_length=2, max_length=2)]] = None,
        spot: Optional[Any] = None,
        gpus_range: Optional[Annotated[
            List[StrictInt], Field(min_length=2, max_length=2)]] = None,
        gpu_names: Optional[List[StrictStr]] = None,
        zones: Optional[List[StrictStr]] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Available Machine Types

        List available machine types for the given provider and zone.

        :param provider_id: (required)
        :type provider_id: Providers
        :param machine_families:
        :type machine_families: List[str]
        :param machine_configs:
        :type machine_configs: List[str]
        :param vcpus_range:
        :type vcpus_range: List[int]
        :param memory_range:
        :type memory_range: List[int]
        :param price_range:
        :type price_range: List[float]
        :param spot:
        :type spot: Spot
        :param gpus_range:
        :type gpus_range: List[int]
        :param gpu_names:
        :type gpu_names: List[str]
        :param zones:
        :type zones: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_available_machine_types_pricing_machine_types_get_serialize(
            provider_id=provider_id,
            machine_families=machine_families,
            machine_configs=machine_configs,
            vcpus_range=vcpus_range,
            memory_range=memory_range,
            price_range=price_range,
            spot=spot,
            gpus_range=gpus_range,
            gpu_names=gpu_names,
            zones=zones,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MachineType]",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_available_machine_types_pricing_machine_types_get_serialize(
        self,
        provider_id,
        machine_families,
        machine_configs,
        vcpus_range,
        memory_range,
        price_range,
        spot,
        gpus_range,
        gpu_names,
        zones,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'machine_families': 'multi',
            'machine_configs': 'multi',
            'vcpus_range': 'multi',
            'memory_range': 'multi',
            'price_range': 'multi',
            'gpus_range': 'multi',
            'gpu_names': 'multi',
            'zones': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[str], List[bytes],
                                List[Tuple[str, bytes]]]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if machine_families is not None:

            _query_params.append(('machine_families', machine_families))

        if machine_configs is not None:

            _query_params.append(('machine_configs', machine_configs))

        if vcpus_range is not None:

            _query_params.append(('vcpus_range', vcpus_range))

        if memory_range is not None:

            _query_params.append(('memory_range', memory_range))

        if price_range is not None:

            _query_params.append(('price_range', price_range))

        if spot is not None:

            _query_params.append(('spot', spot))

        if gpus_range is not None:

            _query_params.append(('gpus_range', gpus_range))

        if gpu_names is not None:

            _query_params.append(('gpu_names', gpu_names))

        if zones is not None:

            _query_params.append(('zones', zones))

        if provider_id is not None:

            _query_params.append(('provider_id', provider_id.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/pricing/machine-types',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)
