"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Continent(str, Enum):
    r"""The 2-letter ISO 3166-1 code representing the continent associated with the location of the user."""

    AF = "AF"
    AN = "AN"
    AS = "AS"
    EU = "EU"
    NA = "NA"
    OC = "OC"
    SA = "SA"


class AnalyticsContinentsTypedDict(TypedDict):
    continent: Continent
    r"""The 2-letter ISO 3166-1 code representing the continent associated with the location of the user."""
    clicks: NotRequired[float]
    r"""The number of clicks from this continent"""
    leads: NotRequired[float]
    r"""The number of leads from this continent"""
    sales: NotRequired[float]
    r"""The number of sales from this continent"""
    sale_amount: NotRequired[float]
    r"""The total amount of sales from this continent, in cents"""


class AnalyticsContinents(BaseModel):
    continent: Continent
    r"""The 2-letter ISO 3166-1 code representing the continent associated with the location of the user."""

    clicks: Optional[float] = 0
    r"""The number of clicks from this continent"""

    leads: Optional[float] = 0
    r"""The number of leads from this continent"""

    sales: Optional[float] = 0
    r"""The number of sales from this continent"""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total amount of sales from this continent, in cents"""
