"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Region(str, Enum):
    WILDCARD_ = "*"


class City(str, Enum):
    WILDCARD_ = "*"


class AnalyticsCountriesTypedDict(TypedDict):
    country: str
    r"""The 2-letter ISO 3166-1 country code of the country. Learn more: https://d.to/geo"""
    region: NotRequired[Region]
    city: NotRequired[City]
    clicks: NotRequired[float]
    r"""The number of clicks from this country"""
    leads: NotRequired[float]
    r"""The number of leads from this country"""
    sales: NotRequired[float]
    r"""The number of sales from this country"""
    sale_amount: NotRequired[float]
    r"""The total amount of sales from this country, in cents"""


class AnalyticsCountries(BaseModel):
    country: str
    r"""The 2-letter ISO 3166-1 country code of the country. Learn more: https://d.to/geo"""

    region: Optional[Region] = Region.WILDCARD_

    city: Optional[City] = City.WILDCARD_

    clicks: Optional[float] = 0
    r"""The number of clicks from this country"""

    leads: Optional[float] = 0
    r"""The number of leads from this country"""

    sales: Optional[float] = 0
    r"""The number of sales from this country"""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total amount of sales from this country, in cents"""
