"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AnalyticsTopLinksTypedDict(TypedDict):
    link: str
    r"""The unique ID of the short link"""
    id: str
    r"""The unique ID of the short link"""
    domain: str
    r"""The domain of the short link"""
    key: str
    r"""The key of the short link"""
    short_link: str
    r"""The short link URL"""
    url: str
    r"""The destination URL of the short link"""
    created_at: str
    r"""The creation timestamp of the short link"""
    comments: NotRequired[Nullable[str]]
    r"""The comments of the short link"""
    title: NotRequired[Nullable[str]]
    r"""The custom link preview title (og:title)"""
    clicks: NotRequired[float]
    r"""The number of clicks from this link"""
    leads: NotRequired[float]
    r"""The number of leads from this link"""
    sales: NotRequired[float]
    r"""The number of sales from this link"""
    sale_amount: NotRequired[float]
    r"""The total amount of sales from this link, in cents"""


class AnalyticsTopLinks(BaseModel):
    link: Annotated[
        str,
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ]
    r"""The unique ID of the short link"""

    id: str
    r"""The unique ID of the short link"""

    domain: str
    r"""The domain of the short link"""

    key: str
    r"""The key of the short link"""

    short_link: Annotated[str, pydantic.Field(alias="shortLink")]
    r"""The short link URL"""

    url: str
    r"""The destination URL of the short link"""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The creation timestamp of the short link"""

    comments: OptionalNullable[str] = UNSET
    r"""The comments of the short link"""

    title: OptionalNullable[str] = UNSET
    r"""The custom link preview title (og:title)"""

    clicks: Optional[float] = 0
    r"""The number of clicks from this link"""

    leads: Optional[float] = 0
    r"""The number of leads from this link"""

    sales: Optional[float] = 0
    r"""The number of sales from this link"""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total amount of sales from this link, in cents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "comments",
            "title",
            "clicks",
            "leads",
            "sales",
            "saleAmount",
        ]
        nullable_fields = ["comments", "title"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
