"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .tagschema import TagSchema, TagSchemaTypedDict
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class Three(str, Enum):
    LINK_DELETED = "link.deleted"


class Two(str, Enum):
    LINK_UPDATED = "link.updated"


class One(str, Enum):
    LINK_CREATED = "link.created"


LinkWebhookEventEventTypedDict = TypeAliasType(
    "LinkWebhookEventEventTypedDict", Union[One, Two, Three]
)


LinkWebhookEventEvent = TypeAliasType("LinkWebhookEventEvent", Union[One, Two, Three])


class LinkWebhookEventTestVariantsTypedDict(TypedDict):
    url: str
    percentage: float


class LinkWebhookEventTestVariants(BaseModel):
    url: str

    percentage: float


class LinkWebhookEventLinkTypedDict(TypedDict):
    id: str
    r"""The unique ID of the short link."""
    domain: str
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""
    key: str
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""
    url: str
    track_conversion: bool
    external_id: Nullable[str]
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""
    tenant_id: Nullable[str]
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""
    program_id: Nullable[str]
    r"""The ID of the program the short link is associated with."""
    partner_id: Nullable[str]
    r"""The ID of the partner the short link is associated with."""
    archived: bool
    expires_at: str
    expired_url: Nullable[str]
    password: Nullable[str]
    r"""The password required to access the destination URL of the short link."""
    proxy: bool
    title: Nullable[str]
    r"""The title of the short link. Will be used for Custom Link Previews if `proxy` is true."""
    description: Nullable[str]
    r"""The description of the short link. Will be used for Custom Link Previews if `proxy` is true."""
    image: Nullable[str]
    r"""The image of the short link. Will be used for Custom Link Previews if `proxy` is true."""
    video: Nullable[str]
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    rewrite: bool
    do_index: bool
    ios: Nullable[str]
    r"""The iOS destination URL for the short link for iOS device targeting."""
    android: Nullable[str]
    r"""The Android destination URL for the short link for Android device targeting."""
    geo: Nullable[Dict[str, str]]
    r"""Geo targeting information for the short link in JSON format `{[COUNTRY]: https://example.com }`. See https://d.to/geo for more information."""
    public_stats: bool
    tags: Nullable[List[TagSchemaTypedDict]]
    r"""The tags assigned to the short link."""
    folder_id: Nullable[str]
    r"""The unique ID of the folder assigned to the short link."""
    webhook_ids: List[str]
    r"""The IDs of the webhooks that the short link is associated with."""
    comments: Nullable[str]
    r"""The comments for the short link."""
    short_link: str
    r"""The full URL of the short link, including the https protocol (e.g. `https://dub.sh/try`)."""
    qr_code: str
    r"""The full URL of the QR code for the short link (e.g. `https://api.dub.co/qr?url=https://dub.sh/try`)."""
    utm_source: Nullable[str]
    r"""The UTM source of the short link."""
    utm_medium: Nullable[str]
    r"""The UTM medium of the short link."""
    utm_campaign: Nullable[str]
    r"""The UTM campaign of the short link."""
    utm_term: Nullable[str]
    r"""The UTM term of the short link."""
    utm_content: Nullable[str]
    r"""The UTM content of the short link."""
    test_started_at: Nullable[str]
    test_completed_at: Nullable[str]
    user_id: Nullable[str]
    workspace_id: str
    r"""The workspace ID of the short link."""
    last_clicked: str
    created_at: str
    updated_at: str
    tag_id: Nullable[str]
    r"""Deprecated: Use `tags` instead. The unique ID of the tag assigned to the short link."""
    project_id: str
    r"""Deprecated: Use `workspaceId` instead. The project ID of the short link."""
    test_variants: NotRequired[Nullable[List[LinkWebhookEventTestVariantsTypedDict]]]
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""
    clicks: NotRequired[float]
    r"""The number of clicks on the short link."""
    leads: NotRequired[float]
    r"""The number of leads the short link has generated."""
    conversions: NotRequired[float]
    r"""The number of leads that converted to paying customers."""
    sales: NotRequired[float]
    r"""The total number of sales (includes recurring sales) generated by the short link."""
    sale_amount: NotRequired[float]
    r"""The total dollar value of sales (in cents) generated by the short link."""


class LinkWebhookEventLink(BaseModel):
    id: str
    r"""The unique ID of the short link."""

    domain: str
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""

    key: str
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""

    url: str

    track_conversion: Annotated[bool, pydantic.Field(alias="trackConversion")]

    external_id: Annotated[Nullable[str], pydantic.Field(alias="externalId")]
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""

    tenant_id: Annotated[Nullable[str], pydantic.Field(alias="tenantId")]
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""

    program_id: Annotated[Nullable[str], pydantic.Field(alias="programId")]
    r"""The ID of the program the short link is associated with."""

    partner_id: Annotated[Nullable[str], pydantic.Field(alias="partnerId")]
    r"""The ID of the partner the short link is associated with."""

    archived: bool

    expires_at: Annotated[str, pydantic.Field(alias="expiresAt")]

    expired_url: Annotated[Nullable[str], pydantic.Field(alias="expiredUrl")]

    password: Nullable[str]
    r"""The password required to access the destination URL of the short link."""

    proxy: bool

    title: Nullable[str]
    r"""The title of the short link. Will be used for Custom Link Previews if `proxy` is true."""

    description: Nullable[str]
    r"""The description of the short link. Will be used for Custom Link Previews if `proxy` is true."""

    image: Nullable[str]
    r"""The image of the short link. Will be used for Custom Link Previews if `proxy` is true."""

    video: Nullable[str]
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    rewrite: bool

    do_index: Annotated[bool, pydantic.Field(alias="doIndex")]

    ios: Nullable[str]
    r"""The iOS destination URL for the short link for iOS device targeting."""

    android: Nullable[str]
    r"""The Android destination URL for the short link for Android device targeting."""

    geo: Nullable[Dict[str, str]]
    r"""Geo targeting information for the short link in JSON format `{[COUNTRY]: https://example.com }`. See https://d.to/geo for more information."""

    public_stats: Annotated[bool, pydantic.Field(alias="publicStats")]

    tags: Nullable[List[TagSchema]]
    r"""The tags assigned to the short link."""

    folder_id: Annotated[Nullable[str], pydantic.Field(alias="folderId")]
    r"""The unique ID of the folder assigned to the short link."""

    webhook_ids: Annotated[List[str], pydantic.Field(alias="webhookIds")]
    r"""The IDs of the webhooks that the short link is associated with."""

    comments: Nullable[str]
    r"""The comments for the short link."""

    short_link: Annotated[str, pydantic.Field(alias="shortLink")]
    r"""The full URL of the short link, including the https protocol (e.g. `https://dub.sh/try`)."""

    qr_code: Annotated[str, pydantic.Field(alias="qrCode")]
    r"""The full URL of the QR code for the short link (e.g. `https://api.dub.co/qr?url=https://dub.sh/try`)."""

    utm_source: Nullable[str]
    r"""The UTM source of the short link."""

    utm_medium: Nullable[str]
    r"""The UTM medium of the short link."""

    utm_campaign: Nullable[str]
    r"""The UTM campaign of the short link."""

    utm_term: Nullable[str]
    r"""The UTM term of the short link."""

    utm_content: Nullable[str]
    r"""The UTM content of the short link."""

    test_started_at: Annotated[Nullable[str], pydantic.Field(alias="testStartedAt")]

    test_completed_at: Annotated[Nullable[str], pydantic.Field(alias="testCompletedAt")]

    user_id: Annotated[Nullable[str], pydantic.Field(alias="userId")]

    workspace_id: Annotated[str, pydantic.Field(alias="workspaceId")]
    r"""The workspace ID of the short link."""

    last_clicked: Annotated[str, pydantic.Field(alias="lastClicked")]

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]

    tag_id: Annotated[
        Nullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="tagId",
        ),
    ]
    r"""Deprecated: Use `tags` instead. The unique ID of the tag assigned to the short link."""

    project_id: Annotated[
        str,
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="projectId",
        ),
    ]
    r"""Deprecated: Use `workspaceId` instead. The project ID of the short link."""

    test_variants: Annotated[
        OptionalNullable[List[LinkWebhookEventTestVariants]],
        pydantic.Field(alias="testVariants"),
    ] = UNSET
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""

    clicks: Optional[float] = 0
    r"""The number of clicks on the short link."""

    leads: Optional[float] = 0
    r"""The number of leads the short link has generated."""

    conversions: Optional[float] = 0
    r"""The number of leads that converted to paying customers."""

    sales: Optional[float] = 0
    r"""The total number of sales (includes recurring sales) generated by the short link."""

    sale_amount: Annotated[Optional[float], pydantic.Field(alias="saleAmount")] = 0
    r"""The total dollar value of sales (in cents) generated by the short link."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "testVariants",
            "clicks",
            "leads",
            "conversions",
            "sales",
            "saleAmount",
        ]
        nullable_fields = [
            "externalId",
            "tenantId",
            "programId",
            "partnerId",
            "expiredUrl",
            "password",
            "title",
            "description",
            "image",
            "video",
            "ios",
            "android",
            "geo",
            "tags",
            "folderId",
            "comments",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "testVariants",
            "testStartedAt",
            "testCompletedAt",
            "userId",
            "tagId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LinkWebhookEventTypedDict(TypedDict):
    r"""Triggered when a link is created, updated, or deleted."""

    id: str
    event: LinkWebhookEventEventTypedDict
    created_at: str
    data: LinkWebhookEventLinkTypedDict


class LinkWebhookEvent(BaseModel):
    r"""Triggered when a link is created, updated, or deleted."""

    id: str

    event: LinkWebhookEventEvent

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]

    data: LinkWebhookEventLink
