"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.errors import DubError
from dub.types import BaseModel
from enum import Enum
import httpx
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class Code(str, Enum):
    r"""A short code indicating the error code returned."""

    BAD_REQUEST = "bad_request"


class ErrorTypedDict(TypedDict):
    code: Code
    r"""A short code indicating the error code returned."""
    message: str
    r"""A human readable explanation of what went wrong."""
    doc_url: NotRequired[str]
    r"""A link to our documentation with more details about this error code"""


class Error(BaseModel):
    code: Code
    r"""A short code indicating the error code returned."""

    message: str
    r"""A human readable explanation of what went wrong."""

    doc_url: Optional[str] = None
    r"""A link to our documentation with more details about this error code"""


class BadRequestData(BaseModel):
    error: Error


class BadRequest(DubError):
    r"""The server cannot or will not process the request due to something that is perceived to be a client error (e.g., malformed request syntax, invalid request message framing, or deceptive request routing)."""

    data: BadRequestData

    def __init__(
        self,
        data: BadRequestData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
