"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.errors import DubError
from dub.types import BaseModel
from enum import Enum
import httpx
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class RateLimitExceededCode(str, Enum):
    r"""A short code indicating the error code returned."""

    RATE_LIMIT_EXCEEDED = "rate_limit_exceeded"


class RateLimitExceededErrorTypedDict(TypedDict):
    code: RateLimitExceededCode
    r"""A short code indicating the error code returned."""
    message: str
    r"""A human readable explanation of what went wrong."""
    doc_url: NotRequired[str]
    r"""A link to our documentation with more details about this error code"""


class RateLimitExceededError(BaseModel):
    code: RateLimitExceededCode
    r"""A short code indicating the error code returned."""

    message: str
    r"""A human readable explanation of what went wrong."""

    doc_url: Optional[str] = None
    r"""A link to our documentation with more details about this error code"""


class RateLimitExceededData(BaseModel):
    error: RateLimitExceededError


class RateLimitExceeded(DubError):
    r"""The user has sent too many requests in a given amount of time (\"rate limiting\")"""

    data: RateLimitExceededData

    def __init__(
        self,
        data: RateLimitExceededData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
