"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.errors import DubError
from dub.types import BaseModel
from enum import Enum
import httpx
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class UnauthorizedCode(str, Enum):
    r"""A short code indicating the error code returned."""

    UNAUTHORIZED = "unauthorized"


class UnauthorizedErrorTypedDict(TypedDict):
    code: UnauthorizedCode
    r"""A short code indicating the error code returned."""
    message: str
    r"""A human readable explanation of what went wrong."""
    doc_url: NotRequired[str]
    r"""A link to our documentation with more details about this error code"""


class UnauthorizedError(BaseModel):
    code: UnauthorizedCode
    r"""A short code indicating the error code returned."""

    message: str
    r"""A human readable explanation of what went wrong."""

    doc_url: Optional[str] = None
    r"""A link to our documentation with more details about this error code"""


class UnauthorizedData(BaseModel):
    error: UnauthorizedError


class Unauthorized(DubError):
    r"""Although the HTTP standard specifies \"unauthorized\", semantically this response means \"unauthenticated\". That is, the client must authenticate itself to get the requested response."""

    data: UnauthorizedData

    def __init__(
        self,
        data: UnauthorizedData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
