"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, UNSET_SENTINEL
from dub.utils import FieldMetadata, QueryParamMetadata
from pydantic import model_serializer
from typing import List, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


DomainsTypedDict = TypeAliasType("DomainsTypedDict", Union[str, List[str]])
r"""The domains to search. We only support .link domains for now."""


Domains = TypeAliasType("Domains", Union[str, List[str]])
r"""The domains to search. We only support .link domains for now."""


class CheckDomainStatusRequestTypedDict(TypedDict):
    domains: DomainsTypedDict
    r"""The domains to search. We only support .link domains for now."""


class CheckDomainStatusRequest(BaseModel):
    domains: Annotated[
        Domains, FieldMetadata(query=QueryParamMetadata(style="form", explode=False))
    ]
    r"""The domains to search. We only support .link domains for now."""


class CheckDomainStatusResponseBodyTypedDict(TypedDict):
    domain: str
    r"""The domain name."""
    available: bool
    r"""Whether the domain is available."""
    price: Nullable[str]
    r"""The price description."""
    premium: Nullable[bool]
    r"""Whether the domain is a premium domain."""


class CheckDomainStatusResponseBody(BaseModel):
    domain: str
    r"""The domain name."""

    available: bool
    r"""Whether the domain is available."""

    price: Nullable[str]
    r"""The price description."""

    premium: Nullable[bool]
    r"""Whether the domain is a premium domain."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["price", "premium"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
