"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from dub.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Type(str, Enum):
    CLICK = "click"
    LEAD = "lead"
    SALE = "sale"
    CUSTOM = "custom"


class QueryParamStatus(str, Enum):
    r"""Filter the list of commissions by their corresponding status."""

    PENDING = "pending"
    PROCESSED = "processed"
    PAID = "paid"
    REFUNDED = "refunded"
    DUPLICATE = "duplicate"
    FRAUD = "fraud"
    CANCELED = "canceled"


class ListCommissionsQueryParamSortBy(str, Enum):
    r"""The field to sort the list of commissions by."""

    CREATED_AT = "createdAt"
    AMOUNT = "amount"


class ListCommissionsQueryParamSortOrder(str, Enum):
    r"""The sort order for the list of commissions."""

    ASC = "asc"
    DESC = "desc"


class ListCommissionsQueryParamInterval(str, Enum):
    r"""The interval to retrieve commissions for."""

    TWENTY_FOURH = "24h"
    SEVEND = "7d"
    THIRTYD = "30d"
    NINETYD = "90d"
    ONEY = "1y"
    MTD = "mtd"
    QTD = "qtd"
    YTD = "ytd"
    ALL = "all"


class ListCommissionsRequestTypedDict(TypedDict):
    type: NotRequired[Type]
    customer_id: NotRequired[str]
    r"""Filter the list of commissions by the associated customer."""
    payout_id: NotRequired[str]
    r"""Filter the list of commissions by the associated payout."""
    partner_id: NotRequired[str]
    r"""Filter the list of commissions by the associated partner."""
    group_id: NotRequired[str]
    r"""Filter the list of commissions by the associated partner group."""
    invoice_id: NotRequired[str]
    r"""Filter the list of commissions by the associated invoice. Since invoiceId is unique on a per-program basis, this will only return one commission per invoice."""
    status: NotRequired[QueryParamStatus]
    r"""Filter the list of commissions by their corresponding status."""
    sort_by: NotRequired[ListCommissionsQueryParamSortBy]
    r"""The field to sort the list of commissions by."""
    sort_order: NotRequired[ListCommissionsQueryParamSortOrder]
    r"""The sort order for the list of commissions."""
    interval: NotRequired[ListCommissionsQueryParamInterval]
    r"""The interval to retrieve commissions for."""
    start: NotRequired[str]
    r"""The start date of the date range to filter the commissions by."""
    end: NotRequired[str]
    r"""The end date of the date range to filter the commissions by."""
    page: NotRequired[float]
    r"""The page number for pagination."""
    page_size: NotRequired[float]
    r"""The number of items per page."""


class ListCommissionsRequest(BaseModel):
    type: Annotated[
        Optional[Type],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None

    customer_id: Annotated[
        Optional[str],
        pydantic.Field(alias="customerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the list of commissions by the associated customer."""

    payout_id: Annotated[
        Optional[str],
        pydantic.Field(alias="payoutId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the list of commissions by the associated payout."""

    partner_id: Annotated[
        Optional[str],
        pydantic.Field(alias="partnerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the list of commissions by the associated partner."""

    group_id: Annotated[
        Optional[str],
        pydantic.Field(alias="groupId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the list of commissions by the associated partner group."""

    invoice_id: Annotated[
        Optional[str],
        pydantic.Field(alias="invoiceId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the list of commissions by the associated invoice. Since invoiceId is unique on a per-program basis, this will only return one commission per invoice."""

    status: Annotated[
        Optional[QueryParamStatus],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter the list of commissions by their corresponding status."""

    sort_by: Annotated[
        Optional[ListCommissionsQueryParamSortBy],
        pydantic.Field(alias="sortBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListCommissionsQueryParamSortBy.CREATED_AT
    r"""The field to sort the list of commissions by."""

    sort_order: Annotated[
        Optional[ListCommissionsQueryParamSortOrder],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListCommissionsQueryParamSortOrder.DESC
    r"""The sort order for the list of commissions."""

    interval: Annotated[
        Optional[ListCommissionsQueryParamInterval],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = ListCommissionsQueryParamInterval.ALL
    r"""The interval to retrieve commissions for."""

    start: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The start date of the date range to filter the commissions by."""

    end: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The end date of the date range to filter the commissions by."""

    page: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1
    r"""The page number for pagination."""

    page_size: Annotated[
        Optional[float],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100
    r"""The number of items per page."""


class ListCommissionsType(str, Enum):
    CLICK = "click"
    LEAD = "lead"
    SALE = "sale"
    CUSTOM = "custom"


class ListCommissionsStatus(str, Enum):
    PENDING = "pending"
    PROCESSED = "processed"
    PAID = "paid"
    REFUNDED = "refunded"
    DUPLICATE = "duplicate"
    FRAUD = "fraud"
    CANCELED = "canceled"


class ListCommissionsPartnerTypedDict(TypedDict):
    id: str
    r"""The partner's unique ID on Dub."""
    name: str
    r"""The partner's full legal name."""
    email: Nullable[str]
    r"""The partner's email address. Should be a unique value across Dub."""
    image: Nullable[str]
    r"""The partner's avatar image."""
    payouts_enabled_at: Nullable[str]
    r"""The date when the partner enabled payouts."""
    country: Nullable[str]
    r"""The partner's country (required for tax purposes)."""


class ListCommissionsPartner(BaseModel):
    id: str
    r"""The partner's unique ID on Dub."""

    name: str
    r"""The partner's full legal name."""

    email: Nullable[str]
    r"""The partner's email address. Should be a unique value across Dub."""

    image: Nullable[str]
    r"""The partner's avatar image."""

    payouts_enabled_at: Annotated[
        Nullable[str], pydantic.Field(alias="payoutsEnabledAt")
    ]
    r"""The date when the partner enabled payouts."""

    country: Nullable[str]
    r"""The partner's country (required for tax purposes)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["email", "image", "payoutsEnabledAt", "country"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCommissionsCustomerTypedDict(TypedDict):
    id: str
    r"""The unique ID of the customer. You may use either the customer's `id` on Dub (obtained via `/customers` endpoint) or their `externalId` (unique ID within your system, prefixed with `ext_`, e.g. `ext_123`)."""
    external_id: str
    r"""Unique identifier for the customer in the client's app."""
    name: str
    r"""Name of the customer."""
    created_at: str
    r"""The date the customer was created."""
    email: NotRequired[Nullable[str]]
    r"""Email of the customer."""
    avatar: NotRequired[Nullable[str]]
    r"""Avatar URL of the customer."""
    country: NotRequired[Nullable[str]]
    r"""Country of the customer."""
    sales: NotRequired[Nullable[float]]
    r"""Total number of sales for the customer."""
    sale_amount: NotRequired[Nullable[float]]
    r"""Total amount of sales for the customer."""


class ListCommissionsCustomer(BaseModel):
    id: str
    r"""The unique ID of the customer. You may use either the customer's `id` on Dub (obtained via `/customers` endpoint) or their `externalId` (unique ID within your system, prefixed with `ext_`, e.g. `ext_123`)."""

    external_id: Annotated[str, pydantic.Field(alias="externalId")]
    r"""Unique identifier for the customer in the client's app."""

    name: str
    r"""Name of the customer."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date the customer was created."""

    email: OptionalNullable[str] = UNSET
    r"""Email of the customer."""

    avatar: OptionalNullable[str] = UNSET
    r"""Avatar URL of the customer."""

    country: OptionalNullable[str] = UNSET
    r"""Country of the customer."""

    sales: OptionalNullable[float] = UNSET
    r"""Total number of sales for the customer."""

    sale_amount: Annotated[
        OptionalNullable[float], pydantic.Field(alias="saleAmount")
    ] = UNSET
    r"""Total amount of sales for the customer."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["email", "avatar", "country", "sales", "saleAmount"]
        nullable_fields = ["email", "avatar", "country", "sales", "saleAmount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListCommissionsResponseBodyTypedDict(TypedDict):
    id: str
    r"""The commission's unique ID on Dub."""
    amount: float
    earnings: float
    currency: str
    status: ListCommissionsStatus
    invoice_id: Nullable[str]
    description: Nullable[str]
    quantity: float
    created_at: str
    updated_at: str
    partner: ListCommissionsPartnerTypedDict
    type: NotRequired[ListCommissionsType]
    user_id: NotRequired[Nullable[str]]
    r"""The user who created the manual commission."""
    customer: NotRequired[Nullable[ListCommissionsCustomerTypedDict]]


class ListCommissionsResponseBody(BaseModel):
    id: str
    r"""The commission's unique ID on Dub."""

    amount: float

    earnings: float

    currency: str

    status: ListCommissionsStatus

    invoice_id: Annotated[Nullable[str], pydantic.Field(alias="invoiceId")]

    description: Nullable[str]

    quantity: float

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]

    partner: ListCommissionsPartner

    type: Optional[ListCommissionsType] = None

    user_id: Annotated[OptionalNullable[str], pydantic.Field(alias="userId")] = UNSET
    r"""The user who created the manual commission."""

    customer: OptionalNullable[ListCommissionsCustomer] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "userId", "customer"]
        nullable_fields = ["invoiceId", "description", "userId", "customer"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
