"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.components import (
    clickevent as components_clickevent,
    continentcode as components_continentcode,
    leadevent as components_leadevent,
    saleevent as components_saleevent,
)
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from dub.utils import FieldMetadata, QueryParamMetadata, get_discriminator
from enum import Enum
import pydantic
from pydantic import Discriminator, Tag, model_serializer
from typing import List, Optional, Union
from typing_extensions import (
    Annotated,
    NotRequired,
    TypeAliasType,
    TypedDict,
    deprecated,
)


class QueryParamEvent(str, Enum):
    r"""The type of event to retrieve analytics for. Defaults to 'clicks'."""

    CLICKS = "clicks"
    LEADS = "leads"
    SALES = "sales"


class QueryParamInterval(str, Enum):
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""

    TWENTY_FOURH = "24h"
    SEVEND = "7d"
    THIRTYD = "30d"
    NINETYD = "90d"
    ONEY = "1y"
    MTD = "mtd"
    QTD = "qtd"
    YTD = "ytd"
    ALL = "all"


class QueryParamTrigger(str, Enum):
    r"""The trigger to retrieve analytics for. If undefined, returns all trigger types."""

    QR = "qr"
    LINK = "link"
    PAGEVIEW = "pageview"
    DEEPLINK = "deeplink"


ListEventsQueryParamTagIdsTypedDict = TypeAliasType(
    "ListEventsQueryParamTagIdsTypedDict", Union[str, List[str]]
)
r"""The tag IDs to retrieve analytics for."""


ListEventsQueryParamTagIds = TypeAliasType(
    "ListEventsQueryParamTagIds", Union[str, List[str]]
)
r"""The tag IDs to retrieve analytics for."""


class QueryParamSaleType(str, Enum):
    r"""Filter sales by type: 'new' for first-time purchases, 'recurring' for repeat purchases. If undefined, returns both."""

    NEW = "new"
    RECURRING = "recurring"


class QueryParamSortOrder(str, Enum):
    r"""The sort order. The default is `desc`."""

    ASC = "asc"
    DESC = "desc"


class QueryParamSortBy(str, Enum):
    r"""The field to sort the events by. The default is `timestamp`."""

    TIMESTAMP = "timestamp"


@deprecated(
    "warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
)
class Order(str, Enum):
    r"""DEPRECATED. Use `sortOrder` instead."""

    ASC = "asc"
    DESC = "desc"


class ListEventsRequestTypedDict(TypedDict):
    event: NotRequired[QueryParamEvent]
    r"""The type of event to retrieve analytics for. Defaults to 'clicks'."""
    domain: NotRequired[str]
    r"""The domain to filter analytics for."""
    key: NotRequired[str]
    r"""The slug of the short link to retrieve analytics for. Must be used along with the corresponding `domain` of the short link to fetch analytics for a specific short link."""
    link_id: NotRequired[str]
    r"""The unique ID of the short link on Dub to retrieve analytics for."""
    external_id: NotRequired[str]
    r"""The ID of the link in the your database. Must be prefixed with 'ext_' when passed as a query parameter."""
    tenant_id: NotRequired[str]
    r"""The ID of the tenant that created the link inside your system."""
    program_id: NotRequired[str]
    r"""The ID of the program to retrieve analytics for."""
    partner_id: NotRequired[str]
    r"""The ID of the partner to retrieve analytics for."""
    customer_id: NotRequired[str]
    r"""The ID of the customer to retrieve analytics for."""
    interval: NotRequired[QueryParamInterval]
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""
    start: NotRequired[str]
    r"""The start date and time when to retrieve analytics from. If set, takes precedence over `interval`."""
    end: NotRequired[str]
    r"""The end date and time when to retrieve analytics from. If not provided, defaults to the current date. If set along with `start`, takes precedence over `interval`."""
    timezone: NotRequired[str]
    r"""The IANA time zone code for aligning timeseries granularity (e.g. America/New_York). Defaults to UTC."""
    country: NotRequired[str]
    r"""The country to retrieve analytics for. Must be passed as a 2-letter ISO 3166-1 country code. See https://d.to/geo for more information."""
    city: NotRequired[str]
    r"""The city to retrieve analytics for."""
    region: NotRequired[str]
    r"""The ISO 3166-2 region code to retrieve analytics for."""
    continent: NotRequired[components_continentcode.ContinentCode]
    r"""The continent to retrieve analytics for."""
    device: NotRequired[str]
    r"""The device to retrieve analytics for."""
    browser: NotRequired[str]
    r"""The browser to retrieve analytics for."""
    os: NotRequired[str]
    r"""The OS to retrieve analytics for."""
    trigger: NotRequired[QueryParamTrigger]
    r"""The trigger to retrieve analytics for. If undefined, returns all trigger types."""
    referer: NotRequired[str]
    r"""The referer to retrieve analytics for."""
    referer_url: NotRequired[str]
    r"""The full referer URL to retrieve analytics for."""
    url: NotRequired[str]
    r"""The URL to retrieve analytics for."""
    tag_ids: NotRequired[ListEventsQueryParamTagIdsTypedDict]
    r"""The tag IDs to retrieve analytics for."""
    folder_id: NotRequired[str]
    r"""The folder ID to retrieve analytics for. If not provided, return analytics for unsorted links."""
    root: NotRequired[bool]
    r"""Filter for root domains. If true, filter for domains only. If false, filter for links only. If undefined, return both."""
    sale_type: NotRequired[QueryParamSaleType]
    r"""Filter sales by type: 'new' for first-time purchases, 'recurring' for repeat purchases. If undefined, returns both."""
    query: NotRequired[str]
    r"""Search the events by a custom metadata value. Only available for lead and sale events."""
    tag_id: NotRequired[str]
    r"""Deprecated: Use `tagIds` instead. The tag ID to retrieve analytics for."""
    qr: NotRequired[bool]
    r"""Deprecated: Use the `trigger` field instead. Filter for QR code scans. If true, filter for QR codes only. If false, filter for links only. If undefined, return both."""
    utm_source: NotRequired[Nullable[str]]
    r"""The UTM source of the short link."""
    utm_medium: NotRequired[Nullable[str]]
    r"""The UTM medium of the short link."""
    utm_campaign: NotRequired[Nullable[str]]
    r"""The UTM campaign of the short link."""
    utm_term: NotRequired[Nullable[str]]
    r"""The UTM term of the short link."""
    utm_content: NotRequired[Nullable[str]]
    r"""The UTM content of the short link."""
    page: NotRequired[float]
    limit: NotRequired[float]
    sort_order: NotRequired[QueryParamSortOrder]
    r"""The sort order. The default is `desc`."""
    sort_by: NotRequired[QueryParamSortBy]
    r"""The field to sort the events by. The default is `timestamp`."""
    order: NotRequired[Order]
    r"""DEPRECATED. Use `sortOrder` instead."""


class ListEventsRequest(BaseModel):
    event: Annotated[
        Optional[QueryParamEvent],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = QueryParamEvent.CLICKS
    r"""The type of event to retrieve analytics for. Defaults to 'clicks'."""

    domain: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The domain to filter analytics for."""

    key: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The slug of the short link to retrieve analytics for. Must be used along with the corresponding `domain` of the short link to fetch analytics for a specific short link."""

    link_id: Annotated[
        Optional[str],
        pydantic.Field(alias="linkId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The unique ID of the short link on Dub to retrieve analytics for."""

    external_id: Annotated[
        Optional[str],
        pydantic.Field(alias="externalId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the link in the your database. Must be prefixed with 'ext_' when passed as a query parameter."""

    tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="tenantId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the tenant that created the link inside your system."""

    program_id: Annotated[
        Optional[str],
        pydantic.Field(alias="programId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the program to retrieve analytics for."""

    partner_id: Annotated[
        Optional[str],
        pydantic.Field(alias="partnerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the partner to retrieve analytics for."""

    customer_id: Annotated[
        Optional[str],
        pydantic.Field(alias="customerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the customer to retrieve analytics for."""

    interval: Annotated[
        Optional[QueryParamInterval],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""

    start: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The start date and time when to retrieve analytics from. If set, takes precedence over `interval`."""

    end: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The end date and time when to retrieve analytics from. If not provided, defaults to the current date. If set along with `start`, takes precedence over `interval`."""

    timezone: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "UTC"
    r"""The IANA time zone code for aligning timeseries granularity (e.g. America/New_York). Defaults to UTC."""

    country: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The country to retrieve analytics for. Must be passed as a 2-letter ISO 3166-1 country code. See https://d.to/geo for more information."""

    city: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The city to retrieve analytics for."""

    region: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ISO 3166-2 region code to retrieve analytics for."""

    continent: Annotated[
        Optional[components_continentcode.ContinentCode],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The continent to retrieve analytics for."""

    device: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The device to retrieve analytics for."""

    browser: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The browser to retrieve analytics for."""

    os: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The OS to retrieve analytics for."""

    trigger: Annotated[
        Optional[QueryParamTrigger],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The trigger to retrieve analytics for. If undefined, returns all trigger types."""

    referer: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The referer to retrieve analytics for."""

    referer_url: Annotated[
        Optional[str],
        pydantic.Field(alias="refererUrl"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The full referer URL to retrieve analytics for."""

    url: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The URL to retrieve analytics for."""

    tag_ids: Annotated[
        Optional[ListEventsQueryParamTagIds],
        pydantic.Field(alias="tagIds"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The tag IDs to retrieve analytics for."""

    folder_id: Annotated[
        Optional[str],
        pydantic.Field(alias="folderId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The folder ID to retrieve analytics for. If not provided, return analytics for unsorted links."""

    root: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter for root domains. If true, filter for domains only. If false, filter for links only. If undefined, return both."""

    sale_type: Annotated[
        Optional[QueryParamSaleType],
        pydantic.Field(alias="saleType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter sales by type: 'new' for first-time purchases, 'recurring' for repeat purchases. If undefined, returns both."""

    query: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Search the events by a custom metadata value. Only available for lead and sale events."""

    tag_id: Annotated[
        Optional[str],
        pydantic.Field(alias="tagId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Deprecated: Use `tagIds` instead. The tag ID to retrieve analytics for."""

    qr: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Deprecated: Use the `trigger` field instead. Filter for QR code scans. If true, filter for QR codes only. If false, filter for links only. If undefined, return both."""

    utm_source: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM source of the short link."""

    utm_medium: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM medium of the short link."""

    utm_campaign: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM campaign of the short link."""

    utm_term: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM term of the short link."""

    utm_content: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM content of the short link."""

    page: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1

    limit: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 100

    sort_order: Annotated[
        Optional[QueryParamSortOrder],
        pydantic.Field(alias="sortOrder"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = QueryParamSortOrder.DESC
    r"""The sort order. The default is `desc`."""

    sort_by: Annotated[
        Optional[QueryParamSortBy],
        pydantic.Field(alias="sortBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = QueryParamSortBy.TIMESTAMP
    r"""The field to sort the events by. The default is `timestamp`."""

    order: Annotated[
        Optional[Order],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = Order.DESC
    r"""DEPRECATED. Use `sortOrder` instead."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "event",
            "domain",
            "key",
            "linkId",
            "externalId",
            "tenantId",
            "programId",
            "partnerId",
            "customerId",
            "interval",
            "start",
            "end",
            "timezone",
            "country",
            "city",
            "region",
            "continent",
            "device",
            "browser",
            "os",
            "trigger",
            "referer",
            "refererUrl",
            "url",
            "tagIds",
            "folderId",
            "root",
            "saleType",
            "query",
            "tagId",
            "qr",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "page",
            "limit",
            "sortOrder",
            "sortBy",
            "order",
        ]
        nullable_fields = [
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


ListEventsResponseBodyTypedDict = TypeAliasType(
    "ListEventsResponseBodyTypedDict",
    Union[
        components_clickevent.ClickEventTypedDict,
        components_leadevent.LeadEventTypedDict,
        components_saleevent.SaleEventTypedDict,
    ],
)


ListEventsResponseBody = Annotated[
    Union[
        Annotated[components_clickevent.ClickEvent, Tag("click")],
        Annotated[components_leadevent.LeadEvent, Tag("lead")],
        Annotated[components_saleevent.SaleEvent, Tag("sale")],
    ],
    Discriminator(lambda m: get_discriminator(m, "event", "event")),
]
