"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.models.components import (
    analyticsbrowsers as components_analyticsbrowsers,
    analyticscities as components_analyticscities,
    analyticscontinents as components_analyticscontinents,
    analyticscount as components_analyticscount,
    analyticscountries as components_analyticscountries,
    analyticsdevices as components_analyticsdevices,
    analyticsos as components_analyticsos,
    analyticsreferers as components_analyticsreferers,
    analyticsrefererurls as components_analyticsrefererurls,
    analyticsregions as components_analyticsregions,
    analyticstimeseries as components_analyticstimeseries,
    analyticstoplinks as components_analyticstoplinks,
    analyticstopurls as components_analyticstopurls,
    analyticstriggers as components_analyticstriggers,
    continentcode as components_continentcode,
)
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from dub.utils import FieldMetadata, QueryParamMetadata
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class Event(str, Enum):
    r"""The type of event to retrieve analytics for. Defaults to `clicks`."""

    CLICKS = "clicks"
    LEADS = "leads"
    SALES = "sales"
    COMPOSITE = "composite"


class QueryParamGroupBy(str, Enum):
    r"""The parameter to group the analytics data points by. Defaults to `count` if undefined."""

    COUNT = "count"
    TIMESERIES = "timeseries"
    CONTINENTS = "continents"
    REGIONS = "regions"
    COUNTRIES = "countries"
    CITIES = "cities"
    DEVICES = "devices"
    BROWSERS = "browsers"
    OS = "os"
    TRIGGER = "trigger"
    TRIGGERS = "triggers"
    REFERERS = "referers"
    REFERER_URLS = "referer_urls"
    TOP_PARTNERS = "top_partners"
    TOP_LINKS = "top_links"
    TOP_URLS = "top_urls"
    UTM_SOURCES = "utm_sources"
    UTM_MEDIUMS = "utm_mediums"
    UTM_CAMPAIGNS = "utm_campaigns"
    UTM_TERMS = "utm_terms"
    UTM_CONTENTS = "utm_contents"


class Interval(str, Enum):
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""

    TWENTY_FOURH = "24h"
    SEVEND = "7d"
    THIRTYD = "30d"
    NINETYD = "90d"
    ONEY = "1y"
    MTD = "mtd"
    QTD = "qtd"
    YTD = "ytd"
    ALL = "all"


class Trigger(str, Enum):
    r"""The trigger to retrieve analytics for. If undefined, returns all trigger types."""

    QR = "qr"
    LINK = "link"
    PAGEVIEW = "pageview"
    DEEPLINK = "deeplink"


RetrieveAnalyticsQueryParamTagIdsTypedDict = TypeAliasType(
    "RetrieveAnalyticsQueryParamTagIdsTypedDict", Union[str, List[str]]
)
r"""The tag IDs to retrieve analytics for."""


RetrieveAnalyticsQueryParamTagIds = TypeAliasType(
    "RetrieveAnalyticsQueryParamTagIds", Union[str, List[str]]
)
r"""The tag IDs to retrieve analytics for."""


class SaleType(str, Enum):
    r"""Filter sales by type: 'new' for first-time purchases, 'recurring' for repeat purchases. If undefined, returns both."""

    NEW = "new"
    RECURRING = "recurring"


class RetrieveAnalyticsRequestTypedDict(TypedDict):
    event: NotRequired[Event]
    r"""The type of event to retrieve analytics for. Defaults to `clicks`."""
    group_by: NotRequired[QueryParamGroupBy]
    r"""The parameter to group the analytics data points by. Defaults to `count` if undefined."""
    domain: NotRequired[str]
    r"""The domain to filter analytics for."""
    key: NotRequired[str]
    r"""The slug of the short link to retrieve analytics for. Must be used along with the corresponding `domain` of the short link to fetch analytics for a specific short link."""
    link_id: NotRequired[str]
    r"""The unique ID of the short link on Dub to retrieve analytics for."""
    external_id: NotRequired[str]
    r"""The ID of the link in the your database. Must be prefixed with 'ext_' when passed as a query parameter."""
    tenant_id: NotRequired[str]
    r"""The ID of the tenant that created the link inside your system."""
    program_id: NotRequired[str]
    r"""The ID of the program to retrieve analytics for."""
    partner_id: NotRequired[str]
    r"""The ID of the partner to retrieve analytics for."""
    customer_id: NotRequired[str]
    r"""The ID of the customer to retrieve analytics for."""
    interval: NotRequired[Interval]
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""
    start: NotRequired[str]
    r"""The start date and time when to retrieve analytics from. If set, takes precedence over `interval`."""
    end: NotRequired[str]
    r"""The end date and time when to retrieve analytics from. If not provided, defaults to the current date. If set along with `start`, takes precedence over `interval`."""
    timezone: NotRequired[str]
    r"""The IANA time zone code for aligning timeseries granularity (e.g. America/New_York). Defaults to UTC."""
    country: NotRequired[str]
    r"""The country to retrieve analytics for. Must be passed as a 2-letter ISO 3166-1 country code. See https://d.to/geo for more information."""
    city: NotRequired[str]
    r"""The city to retrieve analytics for."""
    region: NotRequired[str]
    r"""The ISO 3166-2 region code to retrieve analytics for."""
    continent: NotRequired[components_continentcode.ContinentCode]
    r"""The continent to retrieve analytics for."""
    device: NotRequired[str]
    r"""The device to retrieve analytics for."""
    browser: NotRequired[str]
    r"""The browser to retrieve analytics for."""
    os: NotRequired[str]
    r"""The OS to retrieve analytics for."""
    trigger: NotRequired[Trigger]
    r"""The trigger to retrieve analytics for. If undefined, returns all trigger types."""
    referer: NotRequired[str]
    r"""The referer to retrieve analytics for."""
    referer_url: NotRequired[str]
    r"""The full referer URL to retrieve analytics for."""
    url: NotRequired[str]
    r"""The URL to retrieve analytics for."""
    tag_ids: NotRequired[RetrieveAnalyticsQueryParamTagIdsTypedDict]
    r"""The tag IDs to retrieve analytics for."""
    folder_id: NotRequired[str]
    r"""The folder ID to retrieve analytics for. If not provided, return analytics for unsorted links."""
    root: NotRequired[bool]
    r"""Filter for root domains. If true, filter for domains only. If false, filter for links only. If undefined, return both."""
    sale_type: NotRequired[SaleType]
    r"""Filter sales by type: 'new' for first-time purchases, 'recurring' for repeat purchases. If undefined, returns both."""
    query: NotRequired[str]
    r"""Search the events by a custom metadata value. Only available for lead and sale events."""
    tag_id: NotRequired[str]
    r"""Deprecated: Use `tagIds` instead. The tag ID to retrieve analytics for."""
    qr: NotRequired[bool]
    r"""Deprecated: Use the `trigger` field instead. Filter for QR code scans. If true, filter for QR codes only. If false, filter for links only. If undefined, return both."""
    utm_source: NotRequired[Nullable[str]]
    r"""The UTM source of the short link."""
    utm_medium: NotRequired[Nullable[str]]
    r"""The UTM medium of the short link."""
    utm_campaign: NotRequired[Nullable[str]]
    r"""The UTM campaign of the short link."""
    utm_term: NotRequired[Nullable[str]]
    r"""The UTM term of the short link."""
    utm_content: NotRequired[Nullable[str]]
    r"""The UTM content of the short link."""


class RetrieveAnalyticsRequest(BaseModel):
    event: Annotated[
        Optional[Event],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = Event.CLICKS
    r"""The type of event to retrieve analytics for. Defaults to `clicks`."""

    group_by: Annotated[
        Optional[QueryParamGroupBy],
        pydantic.Field(alias="groupBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = QueryParamGroupBy.COUNT
    r"""The parameter to group the analytics data points by. Defaults to `count` if undefined."""

    domain: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The domain to filter analytics for."""

    key: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The slug of the short link to retrieve analytics for. Must be used along with the corresponding `domain` of the short link to fetch analytics for a specific short link."""

    link_id: Annotated[
        Optional[str],
        pydantic.Field(alias="linkId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The unique ID of the short link on Dub to retrieve analytics for."""

    external_id: Annotated[
        Optional[str],
        pydantic.Field(alias="externalId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the link in the your database. Must be prefixed with 'ext_' when passed as a query parameter."""

    tenant_id: Annotated[
        Optional[str],
        pydantic.Field(alias="tenantId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the tenant that created the link inside your system."""

    program_id: Annotated[
        Optional[str],
        pydantic.Field(alias="programId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the program to retrieve analytics for."""

    partner_id: Annotated[
        Optional[str],
        pydantic.Field(alias="partnerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the partner to retrieve analytics for."""

    customer_id: Annotated[
        Optional[str],
        pydantic.Field(alias="customerId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ID of the customer to retrieve analytics for."""

    interval: Annotated[
        Optional[Interval],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The interval to retrieve analytics for. If undefined, defaults to 24h."""

    start: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The start date and time when to retrieve analytics from. If set, takes precedence over `interval`."""

    end: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The end date and time when to retrieve analytics from. If not provided, defaults to the current date. If set along with `start`, takes precedence over `interval`."""

    timezone: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = "UTC"
    r"""The IANA time zone code for aligning timeseries granularity (e.g. America/New_York). Defaults to UTC."""

    country: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The country to retrieve analytics for. Must be passed as a 2-letter ISO 3166-1 country code. See https://d.to/geo for more information."""

    city: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The city to retrieve analytics for."""

    region: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The ISO 3166-2 region code to retrieve analytics for."""

    continent: Annotated[
        Optional[components_continentcode.ContinentCode],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The continent to retrieve analytics for."""

    device: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The device to retrieve analytics for."""

    browser: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The browser to retrieve analytics for."""

    os: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The OS to retrieve analytics for."""

    trigger: Annotated[
        Optional[Trigger],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The trigger to retrieve analytics for. If undefined, returns all trigger types."""

    referer: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The referer to retrieve analytics for."""

    referer_url: Annotated[
        Optional[str],
        pydantic.Field(alias="refererUrl"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The full referer URL to retrieve analytics for."""

    url: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The URL to retrieve analytics for."""

    tag_ids: Annotated[
        Optional[RetrieveAnalyticsQueryParamTagIds],
        pydantic.Field(alias="tagIds"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The tag IDs to retrieve analytics for."""

    folder_id: Annotated[
        Optional[str],
        pydantic.Field(alias="folderId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The folder ID to retrieve analytics for. If not provided, return analytics for unsorted links."""

    root: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter for root domains. If true, filter for domains only. If false, filter for links only. If undefined, return both."""

    sale_type: Annotated[
        Optional[SaleType],
        pydantic.Field(alias="saleType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Filter sales by type: 'new' for first-time purchases, 'recurring' for repeat purchases. If undefined, returns both."""

    query: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Search the events by a custom metadata value. Only available for lead and sale events."""

    tag_id: Annotated[
        Optional[str],
        pydantic.Field(alias="tagId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Deprecated: Use `tagIds` instead. The tag ID to retrieve analytics for."""

    qr: Annotated[
        Optional[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Deprecated: Use the `trigger` field instead. Filter for QR code scans. If true, filter for QR codes only. If false, filter for links only. If undefined, return both."""

    utm_source: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM source of the short link."""

    utm_medium: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM medium of the short link."""

    utm_campaign: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM campaign of the short link."""

    utm_term: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM term of the short link."""

    utm_content: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The UTM content of the short link."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "event",
            "groupBy",
            "domain",
            "key",
            "linkId",
            "externalId",
            "tenantId",
            "programId",
            "partnerId",
            "customerId",
            "interval",
            "start",
            "end",
            "timezone",
            "country",
            "city",
            "region",
            "continent",
            "device",
            "browser",
            "os",
            "trigger",
            "referer",
            "refererUrl",
            "url",
            "tagIds",
            "folderId",
            "root",
            "saleType",
            "query",
            "tagId",
            "qr",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
        ]
        nullable_fields = [
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


RetrieveAnalyticsResponseBodyTypedDict = TypeAliasType(
    "RetrieveAnalyticsResponseBodyTypedDict",
    Union[
        components_analyticscount.AnalyticsCountTypedDict,
        List[components_analyticstimeseries.AnalyticsTimeseriesTypedDict],
        List[components_analyticscontinents.AnalyticsContinentsTypedDict],
        List[components_analyticscountries.AnalyticsCountriesTypedDict],
        List[components_analyticsregions.AnalyticsRegionsTypedDict],
        List[components_analyticscities.AnalyticsCitiesTypedDict],
        List[components_analyticsdevices.AnalyticsDevicesTypedDict],
        List[components_analyticsbrowsers.AnalyticsBrowsersTypedDict],
        List[components_analyticsos.AnalyticsOSTypedDict],
        List[components_analyticstriggers.AnalyticsTriggersTypedDict],
        List[components_analyticsreferers.AnalyticsReferersTypedDict],
        List[components_analyticsrefererurls.AnalyticsRefererUrlsTypedDict],
        List[components_analyticstoplinks.AnalyticsTopLinksTypedDict],
        List[components_analyticstopurls.AnalyticsTopUrlsTypedDict],
    ],
)
r"""Analytics data"""


RetrieveAnalyticsResponseBody = TypeAliasType(
    "RetrieveAnalyticsResponseBody",
    Union[
        components_analyticscount.AnalyticsCount,
        List[components_analyticstimeseries.AnalyticsTimeseries],
        List[components_analyticscontinents.AnalyticsContinents],
        List[components_analyticscountries.AnalyticsCountries],
        List[components_analyticsregions.AnalyticsRegions],
        List[components_analyticscities.AnalyticsCities],
        List[components_analyticsdevices.AnalyticsDevices],
        List[components_analyticsbrowsers.AnalyticsBrowsers],
        List[components_analyticsos.AnalyticsOS],
        List[components_analyticstriggers.AnalyticsTriggers],
        List[components_analyticsreferers.AnalyticsReferers],
        List[components_analyticsrefererurls.AnalyticsRefererUrls],
        List[components_analyticstoplinks.AnalyticsTopLinks],
        List[components_analyticstopurls.AnalyticsTopUrls],
    ],
)
r"""Analytics data"""
