"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class Mode(str, Enum):
    r"""The mode to use for tracking the lead event. `async` will not block the request; `wait` will block the request until the lead event is fully recorded in Dub."""

    ASYNC = "async"
    WAIT = "wait"


class TrackLeadRequestBodyTypedDict(TypedDict):
    click_id: str
    r"""The unique ID of the click that the lead conversion event is attributed to. You can read this value from `dub_id` cookie."""
    event_name: str
    r"""The name of the lead event to track. Can also be used as a unique identifier to associate a given lead event for a customer for a subsequent sale event (via the `leadEventName` prop in `/track/sale`)."""
    customer_external_id: str
    r"""The unique ID of the customer in your system. Will be used to identify and attribute all future events to this customer."""
    customer_name: NotRequired[Nullable[str]]
    r"""The name of the customer. If not passed, a random name will be generated (e.g. “Big Red Caribou”)."""
    customer_email: NotRequired[Nullable[str]]
    r"""The email address of the customer."""
    customer_avatar: NotRequired[Nullable[str]]
    r"""The avatar URL of the customer."""
    event_quantity: NotRequired[Nullable[float]]
    r"""The numerical value associated with this lead event (e.g., number of provisioned seats in a free trial). If defined as N, the lead event will be tracked N times."""
    mode: NotRequired[Mode]
    r"""The mode to use for tracking the lead event. `async` will not block the request; `wait` will block the request until the lead event is fully recorded in Dub."""
    metadata: NotRequired[Nullable[Dict[str, Any]]]
    r"""Additional metadata to be stored with the lead event. Max 10,000 characters."""


class TrackLeadRequestBody(BaseModel):
    click_id: Annotated[str, pydantic.Field(alias="clickId")]
    r"""The unique ID of the click that the lead conversion event is attributed to. You can read this value from `dub_id` cookie."""

    event_name: Annotated[str, pydantic.Field(alias="eventName")]
    r"""The name of the lead event to track. Can also be used as a unique identifier to associate a given lead event for a customer for a subsequent sale event (via the `leadEventName` prop in `/track/sale`)."""

    customer_external_id: Annotated[str, pydantic.Field(alias="customerExternalId")]
    r"""The unique ID of the customer in your system. Will be used to identify and attribute all future events to this customer."""

    customer_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerName")
    ] = None
    r"""The name of the customer. If not passed, a random name will be generated (e.g. “Big Red Caribou”)."""

    customer_email: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerEmail")
    ] = None
    r"""The email address of the customer."""

    customer_avatar: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerAvatar")
    ] = None
    r"""The avatar URL of the customer."""

    event_quantity: Annotated[
        OptionalNullable[float], pydantic.Field(alias="eventQuantity")
    ] = UNSET
    r"""The numerical value associated with this lead event (e.g., number of provisioned seats in a free trial). If defined as N, the lead event will be tracked N times."""

    mode: Optional[Mode] = Mode.ASYNC
    r"""The mode to use for tracking the lead event. `async` will not block the request; `wait` will block the request until the lead event is fully recorded in Dub."""

    metadata: OptionalNullable[Dict[str, Any]] = UNSET
    r"""Additional metadata to be stored with the lead event. Max 10,000 characters."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "customerName",
            "customerEmail",
            "customerAvatar",
            "eventQuantity",
            "mode",
            "metadata",
        ]
        nullable_fields = [
            "customerName",
            "customerEmail",
            "customerAvatar",
            "eventQuantity",
            "metadata",
        ]
        null_default_fields = ["customerName", "customerEmail", "customerAvatar"]

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ClickTypedDict(TypedDict):
    id: str


class Click(BaseModel):
    id: str


class CustomerTypedDict(TypedDict):
    name: Nullable[str]
    email: Nullable[str]
    avatar: Nullable[str]
    external_id: Nullable[str]


class Customer(BaseModel):
    name: Nullable[str]

    email: Nullable[str]

    avatar: Nullable[str]

    external_id: Annotated[Nullable[str], pydantic.Field(alias="externalId")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["name", "email", "avatar", "externalId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TrackLeadResponseBodyTypedDict(TypedDict):
    r"""A lead was tracked."""

    click: ClickTypedDict
    customer: CustomerTypedDict


class TrackLeadResponseBody(BaseModel):
    r"""A lead was tracked."""

    click: Click

    customer: Customer
