"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET_SENTINEL
from dub.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from enum import Enum
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateFolderAccessLevel(str, Enum):
    r"""The access level of the folder within the workspace."""

    WRITE = "write"
    READ = "read"


class UpdateFolderRequestBodyTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The name of the folder."""
    access_level: NotRequired[Nullable[UpdateFolderAccessLevel]]
    r"""The access level of the folder within the workspace."""


class UpdateFolderRequestBody(BaseModel):
    name: Optional[str] = None
    r"""The name of the folder."""

    access_level: Annotated[
        OptionalNullable[UpdateFolderAccessLevel], pydantic.Field(alias="accessLevel")
    ] = None
    r"""The access level of the folder within the workspace."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["name", "accessLevel"]
        nullable_fields = ["accessLevel"]
        null_default_fields = ["accessLevel"]

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateFolderRequestTypedDict(TypedDict):
    id: str
    r"""The ID of the folder to update."""
    request_body: NotRequired[UpdateFolderRequestBodyTypedDict]


class UpdateFolderRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the folder to update."""

    request_body: Annotated[
        Optional[UpdateFolderRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
