"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from dub.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UpdateLinkTagIdsTypedDict = TypeAliasType(
    "UpdateLinkTagIdsTypedDict", Union[str, List[str]]
)
r"""The unique IDs of the tags assigned to the short link."""


UpdateLinkTagIds = TypeAliasType("UpdateLinkTagIds", Union[str, List[str]])
r"""The unique IDs of the tags assigned to the short link."""


UpdateLinkTagNamesTypedDict = TypeAliasType(
    "UpdateLinkTagNamesTypedDict", Union[str, List[str]]
)
r"""The unique name of the tags assigned to the short link (case insensitive)."""


UpdateLinkTagNames = TypeAliasType("UpdateLinkTagNames", Union[str, List[str]])
r"""The unique name of the tags assigned to the short link (case insensitive)."""


class UpdateLinkTestVariantsTypedDict(TypedDict):
    url: str
    percentage: float


class UpdateLinkTestVariants(BaseModel):
    url: str

    percentage: float


class UpdateLinkRequestBodyTypedDict(TypedDict):
    url: NotRequired[str]
    r"""The destination URL of the short link."""
    domain: NotRequired[str]
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""
    key: NotRequired[str]
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""
    external_id: NotRequired[Nullable[str]]
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""
    tenant_id: NotRequired[Nullable[str]]
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""
    program_id: NotRequired[Nullable[str]]
    r"""The ID of the program the short link is associated with."""
    partner_id: NotRequired[Nullable[str]]
    r"""The ID of the partner the short link is associated with."""
    track_conversion: NotRequired[bool]
    r"""Whether to track conversions for the short link. Defaults to `false` if not provided."""
    archived: NotRequired[bool]
    r"""Whether the short link is archived. Defaults to `false` if not provided."""
    tag_ids: NotRequired[UpdateLinkTagIdsTypedDict]
    r"""The unique IDs of the tags assigned to the short link."""
    tag_names: NotRequired[UpdateLinkTagNamesTypedDict]
    r"""The unique name of the tags assigned to the short link (case insensitive)."""
    folder_id: NotRequired[Nullable[str]]
    r"""The unique ID existing folder to assign the short link to."""
    comments: NotRequired[Nullable[str]]
    r"""The comments for the short link."""
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time when the short link will expire at."""
    expired_url: NotRequired[Nullable[str]]
    r"""The URL to redirect to when the short link has expired."""
    password: NotRequired[Nullable[str]]
    r"""The password required to access the destination URL of the short link."""
    proxy: NotRequired[bool]
    r"""Whether the short link uses Custom Link Previews feature. Defaults to `false` if not provided."""
    title: NotRequired[Nullable[str]]
    r"""The custom link preview title (og:title). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    description: NotRequired[Nullable[str]]
    r"""The custom link preview description (og:description). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    image: NotRequired[Nullable[str]]
    video: NotRequired[Nullable[str]]
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""
    rewrite: NotRequired[bool]
    r"""Whether the short link uses link cloaking. Defaults to `false` if not provided."""
    ios: NotRequired[Nullable[str]]
    r"""The iOS destination URL for the short link for iOS device targeting."""
    android: NotRequired[Nullable[str]]
    r"""The Android destination URL for the short link for Android device targeting."""
    geo: NotRequired[Nullable[Dict[str, str]]]
    r"""Geo targeting information for the short link in JSON format `{[COUNTRY]: https://example.com }`. See https://d.to/geo for more information."""
    do_index: NotRequired[bool]
    r"""Allow search engines to index your short link. Defaults to `false` if not provided. Learn more: https://d.to/noindex"""
    utm_source: NotRequired[Nullable[str]]
    r"""The UTM source of the short link. If set, this will populate or override the UTM source in the destination URL."""
    utm_medium: NotRequired[Nullable[str]]
    r"""The UTM medium of the short link. If set, this will populate or override the UTM medium in the destination URL."""
    utm_campaign: NotRequired[Nullable[str]]
    r"""The UTM campaign of the short link. If set, this will populate or override the UTM campaign in the destination URL."""
    utm_term: NotRequired[Nullable[str]]
    r"""The UTM term of the short link. If set, this will populate or override the UTM term in the destination URL."""
    utm_content: NotRequired[Nullable[str]]
    r"""The UTM content of the short link. If set, this will populate or override the UTM content in the destination URL."""
    ref: NotRequired[Nullable[str]]
    r"""The referral tag of the short link. If set, this will populate or override the `ref` query parameter in the destination URL."""
    webhook_ids: NotRequired[Nullable[List[str]]]
    r"""An array of webhook IDs to trigger when the link is clicked. These webhooks will receive click event data."""
    test_variants: NotRequired[Nullable[List[UpdateLinkTestVariantsTypedDict]]]
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""
    test_started_at: NotRequired[Nullable[str]]
    r"""The date and time when the tests started."""
    test_completed_at: NotRequired[Nullable[str]]
    r"""The date and time when the tests were or will be completed."""
    public_stats: NotRequired[bool]
    r"""Deprecated: Use `dashboard` instead. Whether the short link's stats are publicly accessible. Defaults to `false` if not provided."""
    tag_id: NotRequired[Nullable[str]]
    r"""Deprecated: Use `tagIds` instead. The unique ID of the tag assigned to the short link."""


class UpdateLinkRequestBody(BaseModel):
    url: Optional[str] = None
    r"""The destination URL of the short link."""

    domain: Optional[str] = None
    r"""The domain of the short link. If not provided, the primary domain for the workspace will be used (or `dub.sh` if the workspace has no domains)."""

    key: Optional[str] = None
    r"""The short link slug. If not provided, a random 7-character slug will be generated."""

    external_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="externalId")
    ] = UNSET
    r"""The ID of the link in your database. If set, it can be used to identify the link in future API requests (must be prefixed with 'ext_' when passed as a query parameter). This key is unique across your workspace."""

    tenant_id: Annotated[OptionalNullable[str], pydantic.Field(alias="tenantId")] = (
        UNSET
    )
    r"""The ID of the tenant that created the link inside your system. If set, it can be used to fetch all links for a tenant."""

    program_id: Annotated[OptionalNullable[str], pydantic.Field(alias="programId")] = (
        UNSET
    )
    r"""The ID of the program the short link is associated with."""

    partner_id: Annotated[OptionalNullable[str], pydantic.Field(alias="partnerId")] = (
        UNSET
    )
    r"""The ID of the partner the short link is associated with."""

    track_conversion: Annotated[
        Optional[bool], pydantic.Field(alias="trackConversion")
    ] = None
    r"""Whether to track conversions for the short link. Defaults to `false` if not provided."""

    archived: Optional[bool] = None
    r"""Whether the short link is archived. Defaults to `false` if not provided."""

    tag_ids: Annotated[Optional[UpdateLinkTagIds], pydantic.Field(alias="tagIds")] = (
        None
    )
    r"""The unique IDs of the tags assigned to the short link."""

    tag_names: Annotated[
        Optional[UpdateLinkTagNames], pydantic.Field(alias="tagNames")
    ] = None
    r"""The unique name of the tags assigned to the short link (case insensitive)."""

    folder_id: Annotated[OptionalNullable[str], pydantic.Field(alias="folderId")] = (
        UNSET
    )
    r"""The unique ID existing folder to assign the short link to."""

    comments: OptionalNullable[str] = UNSET
    r"""The comments for the short link."""

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time when the short link will expire at."""

    expired_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="expiredUrl")
    ] = UNSET
    r"""The URL to redirect to when the short link has expired."""

    password: OptionalNullable[str] = UNSET
    r"""The password required to access the destination URL of the short link."""

    proxy: Optional[bool] = None
    r"""Whether the short link uses Custom Link Previews feature. Defaults to `false` if not provided."""

    title: OptionalNullable[str] = UNSET
    r"""The custom link preview title (og:title). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    description: OptionalNullable[str] = UNSET
    r"""The custom link preview description (og:description). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    image: OptionalNullable[str] = UNSET

    video: OptionalNullable[str] = UNSET
    r"""The custom link preview video (og:video). Will be used for Custom Link Previews if `proxy` is true. Learn more: https://d.to/og"""

    rewrite: Optional[bool] = None
    r"""Whether the short link uses link cloaking. Defaults to `false` if not provided."""

    ios: OptionalNullable[str] = UNSET
    r"""The iOS destination URL for the short link for iOS device targeting."""

    android: OptionalNullable[str] = UNSET
    r"""The Android destination URL for the short link for Android device targeting."""

    geo: OptionalNullable[Dict[str, str]] = UNSET
    r"""Geo targeting information for the short link in JSON format `{[COUNTRY]: https://example.com }`. See https://d.to/geo for more information."""

    do_index: Annotated[Optional[bool], pydantic.Field(alias="doIndex")] = None
    r"""Allow search engines to index your short link. Defaults to `false` if not provided. Learn more: https://d.to/noindex"""

    utm_source: OptionalNullable[str] = UNSET
    r"""The UTM source of the short link. If set, this will populate or override the UTM source in the destination URL."""

    utm_medium: OptionalNullable[str] = UNSET
    r"""The UTM medium of the short link. If set, this will populate or override the UTM medium in the destination URL."""

    utm_campaign: OptionalNullable[str] = UNSET
    r"""The UTM campaign of the short link. If set, this will populate or override the UTM campaign in the destination URL."""

    utm_term: OptionalNullable[str] = UNSET
    r"""The UTM term of the short link. If set, this will populate or override the UTM term in the destination URL."""

    utm_content: OptionalNullable[str] = UNSET
    r"""The UTM content of the short link. If set, this will populate or override the UTM content in the destination URL."""

    ref: OptionalNullable[str] = UNSET
    r"""The referral tag of the short link. If set, this will populate or override the `ref` query parameter in the destination URL."""

    webhook_ids: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="webhookIds")
    ] = UNSET
    r"""An array of webhook IDs to trigger when the link is clicked. These webhooks will receive click event data."""

    test_variants: Annotated[
        OptionalNullable[List[UpdateLinkTestVariants]],
        pydantic.Field(alias="testVariants"),
    ] = UNSET
    r"""An array of A/B test URLs and the percentage of traffic to send to each URL."""

    test_started_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="testStartedAt")
    ] = UNSET
    r"""The date and time when the tests started."""

    test_completed_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="testCompletedAt")
    ] = UNSET
    r"""The date and time when the tests were or will be completed."""

    public_stats: Annotated[
        Optional[bool],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="publicStats",
        ),
    ] = None
    r"""Deprecated: Use `dashboard` instead. Whether the short link's stats are publicly accessible. Defaults to `false` if not provided."""

    tag_id: Annotated[
        OptionalNullable[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="tagId",
        ),
    ] = UNSET
    r"""Deprecated: Use `tagIds` instead. The unique ID of the tag assigned to the short link."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "url",
            "domain",
            "key",
            "externalId",
            "tenantId",
            "programId",
            "partnerId",
            "trackConversion",
            "archived",
            "tagIds",
            "tagNames",
            "folderId",
            "comments",
            "expiresAt",
            "expiredUrl",
            "password",
            "proxy",
            "title",
            "description",
            "image",
            "video",
            "rewrite",
            "ios",
            "android",
            "geo",
            "doIndex",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "ref",
            "webhookIds",
            "testVariants",
            "testStartedAt",
            "testCompletedAt",
            "publicStats",
            "tagId",
        ]
        nullable_fields = [
            "externalId",
            "tenantId",
            "programId",
            "partnerId",
            "folderId",
            "comments",
            "expiresAt",
            "expiredUrl",
            "password",
            "title",
            "description",
            "image",
            "video",
            "ios",
            "android",
            "geo",
            "utm_source",
            "utm_medium",
            "utm_campaign",
            "utm_term",
            "utm_content",
            "ref",
            "webhookIds",
            "testVariants",
            "testStartedAt",
            "testCompletedAt",
            "tagId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateLinkRequestTypedDict(TypedDict):
    link_id: str
    r"""The id of the link to update. You may use either `linkId` (obtained via `/links/info` endpoint) or `externalId` prefixed with `ext_`."""
    request_body: NotRequired[UpdateLinkRequestBodyTypedDict]


class UpdateLinkRequest(BaseModel):
    link_id: Annotated[
        str,
        pydantic.Field(alias="linkId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The id of the link to update. You may use either `linkId` (obtained via `/links/info` endpoint) or `externalId` prefixed with `ext_`."""

    request_body: Annotated[
        Optional[UpdateLinkRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
