"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dub.types import BaseModel
from dub.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from enum import Enum
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateTagColor(str, Enum):
    r"""The color of the tag. If not provided, a random color will be used from the list: red, yellow, green, blue, purple, brown."""

    RED = "red"
    YELLOW = "yellow"
    GREEN = "green"
    BLUE = "blue"
    PURPLE = "purple"
    BROWN = "brown"
    PINK = "pink"


class UpdateTagRequestBodyTypedDict(TypedDict):
    name: NotRequired[str]
    r"""The name of the tag to create."""
    color: NotRequired[UpdateTagColor]
    r"""The color of the tag. If not provided, a random color will be used from the list: red, yellow, green, blue, purple, brown."""
    tag: NotRequired[str]
    r"""The name of the tag to create."""


class UpdateTagRequestBody(BaseModel):
    name: Optional[str] = None
    r"""The name of the tag to create."""

    color: Optional[UpdateTagColor] = None
    r"""The color of the tag. If not provided, a random color will be used from the list: red, yellow, green, blue, purple, brown."""

    tag: Annotated[
        Optional[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible."
        ),
    ] = None
    r"""The name of the tag to create."""


class UpdateTagRequestTypedDict(TypedDict):
    id: str
    r"""The ID of the tag to update."""
    request_body: NotRequired[UpdateTagRequestBodyTypedDict]


class UpdateTagRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the tag to update."""

    request_body: Annotated[
        Optional[UpdateTagRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
