# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.limit import Limit
from ..types.page_token import PageToken
from .raw_client import AsyncRawDomainsClient, RawDomainsClient
from .types.create_domain_response import CreateDomainResponse
from .types.domain import Domain
from .types.domain_id import DomainId
from .types.domain_name import DomainName
from .types.list_domains_response import ListDomainsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DomainsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDomainsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListDomainsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListDomainsResponse

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.list()
        """
        _response = self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    def get(self, domain: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> Domain:
        """
        Parameters
        ----------
        domain : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.get(
            domain=" your-domain.com",
        )
        """
        _response = self._raw_client.get(domain, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        domain: DomainName,
        feedback_enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateDomainResponse:
        """
        Parameters
        ----------
        domain : DomainName

        feedback_enabled : typing.Optional[bool]
            Whether to forward bounce and complaint notifications to your domain.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateDomainResponse

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.create(
            domain="your-domain.com",
        )
        """
        _response = self._raw_client.create(
            domain=domain, feedback_enabled=feedback_enabled, request_options=request_options
        )
        return _response.data

    def delete(self, domain: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.domains.delete(
            domain="dom_12345",
        )
        """
        _response = self._raw_client.delete(domain, request_options=request_options)
        return _response.data


class AsyncDomainsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDomainsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListDomainsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListDomainsResponse

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    async def get(self, domain: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> Domain:
        """
        Parameters
        ----------
        domain : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Domain

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.get(
                domain=" your-domain.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(domain, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        domain: DomainName,
        feedback_enabled: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateDomainResponse:
        """
        Parameters
        ----------
        domain : DomainName

        feedback_enabled : typing.Optional[bool]
            Whether to forward bounce and complaint notifications to your domain.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateDomainResponse

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.create(
                domain="your-domain.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            domain=domain, feedback_enabled=feedback_enabled, request_options=request_options
        )
        return _response.data

    async def delete(self, domain: DomainId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        domain : DomainId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.domains.delete(
                domain="dom_12345",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(domain, request_options=request_options)
        return _response.data
