# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.limit import Limit
from ..types.page_token import PageToken
from .drafts.client import AsyncDraftsClient, DraftsClient
from .messages.client import AsyncMessagesClient, MessagesClient
from .metrics.client import AsyncMetricsClient, MetricsClient
from .raw_client import AsyncRawInboxesClient, RawInboxesClient
from .threads.client import AsyncThreadsClient, ThreadsClient
from .types.client_id import ClientId
from .types.inbox import Inbox
from .types.inbox_id import InboxId
from .types.list_inboxes_response import ListInboxesResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InboxesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInboxesClient(client_wrapper=client_wrapper)
        self.threads = ThreadsClient(client_wrapper=client_wrapper)

        self.messages = MessagesClient(client_wrapper=client_wrapper)

        self.drafts = DraftsClient(client_wrapper=client_wrapper)

        self.metrics = MetricsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInboxesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListInboxesResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListInboxesResponse

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.list()
        """
        _response = self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    def get(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> Inbox:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.get(
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.get(inbox_id, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        username: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Inbox:
        """
        Parameters
        ----------
        username : typing.Optional[str]
            Username of address. Randomly generated if not specified.

        domain : typing.Optional[str]
            Domain of address. Must be verified domain. Defaults to `agentmail.to`.

        display_name : typing.Optional[str]
            Display name: `Display Name <username@domain.com>`. Defaults to `AgentMail`. Pass empty string to omit.

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.create()
        """
        _response = self._raw_client.create(
            username=username,
            domain=domain,
            display_name=display_name,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    def delete(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.delete(
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.delete(inbox_id, request_options=request_options)
        return _response.data


class AsyncInboxesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInboxesClient(client_wrapper=client_wrapper)
        self.threads = AsyncThreadsClient(client_wrapper=client_wrapper)

        self.messages = AsyncMessagesClient(client_wrapper=client_wrapper)

        self.drafts = AsyncDraftsClient(client_wrapper=client_wrapper)

        self.metrics = AsyncMetricsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInboxesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListInboxesResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListInboxesResponse

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    async def get(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> Inbox:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.get(
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(inbox_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        username: typing.Optional[str] = OMIT,
        domain: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Inbox:
        """
        Parameters
        ----------
        username : typing.Optional[str]
            Username of address. Randomly generated if not specified.

        domain : typing.Optional[str]
            Domain of address. Must be verified domain. Defaults to `agentmail.to`.

        display_name : typing.Optional[str]
            Display name: `Display Name <username@domain.com>`. Defaults to `AgentMail`. Pass empty string to omit.

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Inbox

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            username=username,
            domain=domain,
            display_name=display_name,
            client_id=client_id,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, inbox_id: InboxId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        inbox_id : InboxId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.delete(
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(inbox_id, request_options=request_options)
        return _response.data
