# This file was auto-generated by Fern from our API Definition.

import contextlib
import typing
from json.decoder import JSONDecodeError

from ...attachments.types.attachment_id import AttachmentId
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.datetime_utils import serialize_datetime
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.unchecked_base_model import construct_type
from ...errors.not_found_error import NotFoundError
from ...errors.validation_error import ValidationError
from ...messages.errors.message_rejected_error import MessageRejectedError
from ...messages.types.list_messages_response import ListMessagesResponse
from ...messages.types.message import Message
from ...messages.types.message_html import MessageHtml
from ...messages.types.message_id import MessageId
from ...messages.types.message_labels import MessageLabels
from ...messages.types.message_subject import MessageSubject
from ...messages.types.message_text import MessageText
from ...messages.types.send_message_attachments import SendMessageAttachments
from ...messages.types.send_message_bcc import SendMessageBcc
from ...messages.types.send_message_cc import SendMessageCc
from ...messages.types.send_message_reply_to import SendMessageReplyTo
from ...messages.types.send_message_response import SendMessageResponse
from ...messages.types.send_message_to import SendMessageTo
from ...types.after import After
from ...types.ascending import Ascending
from ...types.before import Before
from ...types.error_response import ErrorResponse
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ...types.validation_error_response import ValidationErrorResponse
from ..types.inbox_id import InboxId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawMessagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ListMessagesResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListMessagesResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "before": serialize_datetime(before) if before is not None else None,
                "after": serialize_datetime(after) if after is not None else None,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListMessagesResponse,
                    construct_type(
                        type_=ListMessagesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Message]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Message]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Message,
                    construct_type(
                        type_=Message,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def get_attachment(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        attachment_id: AttachmentId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        attachment_id : AttachmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
        """
        with self._client_wrapper.httpx_client.stream(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}/attachments/{jsonable_encoder(attachment_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 404:
                        raise NotFoundError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                ErrorResponse,
                                construct_type(
                                    type_=ErrorResponse,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()

    @contextlib.contextmanager
    def get_raw(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
        """
        with self._client_wrapper.httpx_client.stream(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}/raw",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        ) as _response:

            def _stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 404:
                        raise NotFoundError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                ErrorResponse,
                                construct_type(
                                    type_=ErrorResponse,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield _stream()

    def send(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        subject: typing.Optional[MessageSubject] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        subject : typing.Optional[MessageSubject]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SendMessageResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/send",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": convert_and_respect_annotation_metadata(
                    object_=reply_to, annotation=SendMessageReplyTo, direction="write"
                ),
                "to": convert_and_respect_annotation_metadata(object_=to, annotation=SendMessageTo, direction="write"),
                "cc": convert_and_respect_annotation_metadata(object_=cc, annotation=SendMessageCc, direction="write"),
                "bcc": convert_and_respect_annotation_metadata(
                    object_=bcc, annotation=SendMessageBcc, direction="write"
                ),
                "subject": subject,
                "text": text,
                "html": html,
                "attachments": convert_and_respect_annotation_metadata(
                    object_=attachments, annotation=SendMessageAttachments, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def reply(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SendMessageResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}/reply",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": convert_and_respect_annotation_metadata(
                    object_=reply_to, annotation=SendMessageReplyTo, direction="write"
                ),
                "to": convert_and_respect_annotation_metadata(object_=to, annotation=SendMessageTo, direction="write"),
                "cc": convert_and_respect_annotation_metadata(object_=cc, annotation=SendMessageCc, direction="write"),
                "bcc": convert_and_respect_annotation_metadata(
                    object_=bcc, annotation=SendMessageBcc, direction="write"
                ),
                "text": text,
                "html": html,
                "attachments": convert_and_respect_annotation_metadata(
                    object_=attachments, annotation=SendMessageAttachments, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Message]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Message]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="PATCH",
            json={
                "add_labels": add_labels,
                "remove_labels": remove_labels,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Message,
                    construct_type(
                        type_=Message,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMessagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ListMessagesResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListMessagesResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "before": serialize_datetime(before) if before is not None else None,
                "after": serialize_datetime(after) if after is not None else None,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListMessagesResponse,
                    construct_type(
                        type_=ListMessagesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Message]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Message]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Message,
                    construct_type(
                        type_=Message,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def get_attachment(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        attachment_id: AttachmentId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        attachment_id : AttachmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}/attachments/{jsonable_encoder(attachment_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 404:
                        raise NotFoundError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                ErrorResponse,
                                construct_type(
                                    type_=ErrorResponse,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()

    @contextlib.asynccontextmanager
    async def get_raw(
        self, inbox_id: InboxId, message_id: MessageId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}/raw",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        ) as _response:

            async def _stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 404:
                        raise NotFoundError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                ErrorResponse,
                                construct_type(
                                    type_=ErrorResponse,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await _stream()

    async def send(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        subject: typing.Optional[MessageSubject] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        subject : typing.Optional[MessageSubject]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SendMessageResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/send",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": convert_and_respect_annotation_metadata(
                    object_=reply_to, annotation=SendMessageReplyTo, direction="write"
                ),
                "to": convert_and_respect_annotation_metadata(object_=to, annotation=SendMessageTo, direction="write"),
                "cc": convert_and_respect_annotation_metadata(object_=cc, annotation=SendMessageCc, direction="write"),
                "bcc": convert_and_respect_annotation_metadata(
                    object_=bcc, annotation=SendMessageBcc, direction="write"
                ),
                "subject": subject,
                "text": text,
                "html": html,
                "attachments": convert_and_respect_annotation_metadata(
                    object_=attachments, annotation=SendMessageAttachments, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def reply(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        labels: typing.Optional[MessageLabels] = OMIT,
        reply_to: typing.Optional[SendMessageReplyTo] = OMIT,
        to: typing.Optional[SendMessageTo] = OMIT,
        cc: typing.Optional[SendMessageCc] = OMIT,
        bcc: typing.Optional[SendMessageBcc] = OMIT,
        text: typing.Optional[MessageText] = OMIT,
        html: typing.Optional[MessageHtml] = OMIT,
        attachments: typing.Optional[SendMessageAttachments] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        labels : typing.Optional[MessageLabels]

        reply_to : typing.Optional[SendMessageReplyTo]

        to : typing.Optional[SendMessageTo]

        cc : typing.Optional[SendMessageCc]

        bcc : typing.Optional[SendMessageBcc]

        text : typing.Optional[MessageText]

        html : typing.Optional[MessageHtml]

        attachments : typing.Optional[SendMessageAttachments]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SendMessageResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}/reply",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": convert_and_respect_annotation_metadata(
                    object_=reply_to, annotation=SendMessageReplyTo, direction="write"
                ),
                "to": convert_and_respect_annotation_metadata(object_=to, annotation=SendMessageTo, direction="write"),
                "cc": convert_and_respect_annotation_metadata(object_=cc, annotation=SendMessageCc, direction="write"),
                "bcc": convert_and_respect_annotation_metadata(
                    object_=bcc, annotation=SendMessageBcc, direction="write"
                ),
                "text": text,
                "html": html,
                "attachments": convert_and_respect_annotation_metadata(
                    object_=attachments, annotation=SendMessageAttachments, direction="write"
                ),
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        inbox_id: InboxId,
        message_id: MessageId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Message]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        message_id : MessageId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Message]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/messages/{jsonable_encoder(message_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="PATCH",
            json={
                "add_labels": add_labels,
                "remove_labels": remove_labels,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Message,
                    construct_type(
                        type_=Message,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
