# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .client_id import ClientId


class CreateInboxRequest(UncheckedBaseModel):
    username: typing.Optional[str] = pydantic.Field(default=None)
    """
    Username of address. Randomly generated if not specified.
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    Domain of address. Must be verified domain. Defaults to `agentmail.to`.
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name: `Display Name <username@domain.com>`. Defaults to `AgentMail`. Pass empty string to omit.
    """

    client_id: typing.Optional[ClientId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
