# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawMetricsClient, RawMetricsClient
from .types.list_metrics_response import ListMetricsResponse
from .types.metric_end_timestamp import MetricEndTimestamp
from .types.metric_event_types import MetricEventTypes
from .types.metric_start_timestamp import MetricStartTimestamp


class MetricsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMetricsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMetricsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMetricsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        start_timestamp: MetricStartTimestamp,
        end_timestamp: MetricEndTimestamp,
        event_types: typing.Optional[MetricEventTypes] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListMetricsResponse:
        """
        Parameters
        ----------
        start_timestamp : MetricStartTimestamp

        end_timestamp : MetricEndTimestamp

        event_types : typing.Optional[MetricEventTypes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListMetricsResponse

        Examples
        --------
        import datetime

        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.metrics.list(
            start_timestamp=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            end_timestamp=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
        )
        """
        _response = self._raw_client.list(
            start_timestamp=start_timestamp,
            end_timestamp=end_timestamp,
            event_types=event_types,
            request_options=request_options,
        )
        return _response.data


class AsyncMetricsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMetricsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMetricsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMetricsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        start_timestamp: MetricStartTimestamp,
        end_timestamp: MetricEndTimestamp,
        event_types: typing.Optional[MetricEventTypes] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListMetricsResponse:
        """
        Parameters
        ----------
        start_timestamp : MetricStartTimestamp

        end_timestamp : MetricEndTimestamp

        event_types : typing.Optional[MetricEventTypes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListMetricsResponse

        Examples
        --------
        import asyncio
        import datetime

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.metrics.list(
                start_timestamp=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                end_timestamp=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            start_timestamp=start_timestamp,
            end_timestamp=end_timestamp,
            event_types=event_types,
            request_options=request_options,
        )
        return _response.data
