# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.limit import Limit
from ..types.page_token import PageToken
from .raw_client import AsyncRawWebhooksClient, RawWebhooksClient
from .types.client_id import ClientId
from .types.event_types import EventTypes
from .types.inbox_ids import InboxIds
from .types.list_webhooks_response import ListWebhooksResponse
from .types.url import Url
from .types.webhook import Webhook
from .types.webhook_id import WebhookId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WebhooksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebhooksClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListWebhooksResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListWebhooksResponse

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.webhooks.list()
        """
        _response = self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    def get(self, webhook_id: WebhookId, *, request_options: typing.Optional[RequestOptions] = None) -> Webhook:
        """
        Parameters
        ----------
        webhook_id : WebhookId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Webhook

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.webhooks.get(
            webhook_id="webhook_id",
        )
        """
        _response = self._raw_client.get(webhook_id, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        url: Url,
        event_types: EventTypes,
        inbox_ids: typing.Optional[InboxIds] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Webhook:
        """
        Parameters
        ----------
        url : Url

        event_types : EventTypes

        inbox_ids : typing.Optional[InboxIds]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Webhook

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.webhooks.create(
            url="url",
            event_types=["message.received", "message.received"],
        )
        """
        _response = self._raw_client.create(
            url=url, event_types=event_types, inbox_ids=inbox_ids, client_id=client_id, request_options=request_options
        )
        return _response.data

    def delete(self, webhook_id: WebhookId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        webhook_id : WebhookId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.webhooks.delete(
            webhook_id="webhook_id",
        )
        """
        _response = self._raw_client.delete(webhook_id, request_options=request_options)
        return _response.data


class AsyncWebhooksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebhooksClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListWebhooksResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListWebhooksResponse

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.webhooks.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(limit=limit, page_token=page_token, request_options=request_options)
        return _response.data

    async def get(self, webhook_id: WebhookId, *, request_options: typing.Optional[RequestOptions] = None) -> Webhook:
        """
        Parameters
        ----------
        webhook_id : WebhookId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Webhook

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.webhooks.get(
                webhook_id="webhook_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(webhook_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        url: Url,
        event_types: EventTypes,
        inbox_ids: typing.Optional[InboxIds] = OMIT,
        client_id: typing.Optional[ClientId] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Webhook:
        """
        Parameters
        ----------
        url : Url

        event_types : EventTypes

        inbox_ids : typing.Optional[InboxIds]

        client_id : typing.Optional[ClientId]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Webhook

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.webhooks.create(
                url="url",
                event_types=["message.received", "message.received"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            url=url, event_types=event_types, inbox_ids=inbox_ids, client_id=client_id, request_options=request_options
        )
        return _response.data

    async def delete(self, webhook_id: WebhookId, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        webhook_id : WebhookId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.webhooks.delete(
                webhook_id="webhook_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(webhook_id, request_options=request_options)
        return _response.data
