from typing import Any, Optional

DEFAULT_NULL_VALUES: Any

class DataType:
    null_values: Any = ...
    def __init__(self, null_values: Any = ...) -> None: ...
    def test(self, d: Any): ...
    def cast(self, d: Any) -> None: ...
    def csvify(self, d: Any): ...
    def jsonify(self, d: Any): ...

DEFAULT_TRUE_VALUES: Any
DEFAULT_FALSE_VALUES: Any

class Boolean(DataType):
    true_values: Any = ...
    false_values: Any = ...
    def __init__(
        self, true_values: Any = ..., false_values: Any = ..., null_values: Any = ...
    ) -> None: ...
    def cast(self, d: Any): ...
    def jsonify(self, d: Any): ...

ZERO_DT: Any

class Date(DataType):
    date_format: Any = ...
    parser: Any = ...
    def __init__(self, date_format: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def cast(self, d: Any): ...
    def csvify(self, d: Any): ...
    def jsonify(self, d: Any): ...

class DateTime(DataType):
    datetime_format: Any = ...
    timezone: Any = ...
    def __init__(
        self, datetime_format: Optional[Any] = ..., timezone: Optional[Any] = ..., **kwargs: Any
    ) -> None: ...
    def cast(self, d: Any): ...
    def csvify(self, d: Any): ...
    def jsonify(self, d: Any): ...

DEFAULT_CURRENCY_SYMBOLS: Any
POSITIVE: Any
NEGATIVE: Any

class Number(DataType):
    locale: Any = ...
    currency_symbols: Any = ...
    group_symbol: Any = ...
    decimal_symbol: Any = ...
    def __init__(
        self,
        locale: str = ...,
        group_symbol: Optional[Any] = ...,
        decimal_symbol: Optional[Any] = ...,
        currency_symbols: Any = ...,
        **kwargs: Any,
    ) -> None: ...
    def cast(self, d: Any): ...
    def jsonify(self, d: Any): ...

class TimeDelta(DataType):
    def cast(self, d: Any): ...

class Text(DataType):
    cast_nulls: Any = ...
    def __init__(self, cast_nulls: bool = ..., **kwargs: Any) -> None: ...
    def cast(self, d: Any): ...
