from typing import Any, Dict, Mapping, Type, TypeVar, Optional

T = TypeVar("T", bound="DataClassDictMixin")

class DataClassDictMixin:
    def __init_subclass__(cls: Type[T], **kwargs: Any) -> None: ...
    def to_dict(self, **kwargs: Any) -> dict: ...
    @classmethod
    def from_dict(cls, d: Mapping, **kwargs: Any) -> Any: ...
    @classmethod
    def __pre_deserialize__(cls: Type[T], d: Dict[Any, Any]) -> Dict[Any, Any]: ...
    @classmethod
    def __post_deserialize__(cls: Type[T], obj: T) -> T: ...
    def __pre_serialize__(self: T, context: Optional[Dict]) -> T: ...
    def __post_serialize__(self, d: Dict[Any, Any], context: Optional[Dict]) -> Dict[Any, Any]: ...
