export declare class Validators {
    /**
     * Validates whether a supplied value conforms to the allowedPattern, granted neither is an unresolved token.
     *
     * @param value          the value to be validated.
     * @param allowedPattern the regular expression to use for validation.
     *
     * @throws if the ``value`` does not conform to the ``allowedPattern`` and neither is an unresolved token (per
     *         ``cdk.unresolved``).
     */
    static parameterValue(value: string, allowedPattern: string): void;
    static parameterName(parameterName: string): void;
    static description(description?: string): void;
}
