# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_sleep_cycle_response import ClientSleepCycleResponse
from .raw_client import AsyncRawSleepCycleClient, RawSleepCycleClient


class SleepCycleClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSleepCycleClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSleepCycleClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSleepCycleClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        start_date: str,
        end_date: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientSleepCycleResponse:
        """
        Get sleep cycle for user_id

        Parameters
        ----------
        user_id : str

        start_date : str

        end_date : typing.Optional[str]

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientSleepCycleResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.sleep_cycle.get(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get(
            user_id, start_date=start_date, end_date=end_date, provider=provider, request_options=request_options
        )
        return _response.data


class AsyncSleepCycleClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSleepCycleClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSleepCycleClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSleepCycleClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        start_date: str,
        end_date: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientSleepCycleResponse:
        """
        Get sleep cycle for user_id

        Parameters
        ----------
        user_id : str

        start_date : str

        end_date : typing.Optional[str]

        provider : typing.Optional[str]
            Provider oura/strava etc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientSleepCycleResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.sleep_cycle.get(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            user_id, start_date=start_date, end_date=end_date, provider=provider, request_options=request_options
        )
        return _response.data
