# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ConnectionRecipe(UniversalBaseModel):
    user_id: str = pydantic.Field()
    """
    Vital User ID. The user must be created ahead of the bulk import operation.
    """

    access_token: str = pydantic.Field()
    """
    * OAuth 2.0 providers (Fitbit, etc): The latest Access Token.
    * OAuth 1.0 providers (Garmin): The Access Token.
    """

    refresh_token: str = pydantic.Field()
    """
    * OAuth 2.0 providers (Fitbit, etc): The latest Refresh Token.
    * OAuth 1.0 providers (Garmin): The Token Secret.
    """

    provider_id: str = pydantic.Field()
    """
    User ID of the data provider.
    
    * Fitbit: 6-character Fitbit User ID 
    * Garmin: 36-character Garmin User ID
    """

    expires_at: int = pydantic.Field()
    """
    Access token expiry date, in terms of UNIX epoch seconds.
    
    * OAuth 2.0 providers (Fitbit, etc): The latest expiry date on your record.
    * OAuth 1.0 providers (Garmin): Use the constant value `2147483647`.
    """

    oauth_scopes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    OAuth scopes of the data provider. Specify `null` if you do not
    have any scopes on record.
    
    * Fitbit: Has scopes
    * Garmin: No scope
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
