"""
Welcome to the world of nguyenpanda,
    a Python library that brings you the essence of utility packages,
    each named after animals, perfectly representing its unique domain.

🐦‍⬛ crow
    Inspired by the crow, one of the most intelligent birds known for its ability
    to use everything around it as a tool to serve its needs,
    this package offers a collection of utility functions designed for
    frequent tasks in Machine Learning and Deep Learning.

    Whether you're managing large datasets or streamlining workflows in Jupyter notebooks,
    the `crow` package provides the tools you need to make your ML/DL projects more efficient and effective.

🦋 butterfly
    Embark on a journey through randomness and chaos with the enigmatic butterfly package.
    Delve into the realms of uncertainty, probability, and statistics.
    Embrace the unpredictable nature of nguyenpanda's butterfly.
    Remember, even the flutter of a butterfly's wings can cause significant changes in a complex system, so seize the opportunity to explore its mysteries.

🦉 owl
    Illuminate the path to mathematical enlightenment with the wisdom of the owl.
    Ascend to mastery in calculus, conquer the realms of linear algebra,
    and traverse the diverse landscapes of mathematics.
    Allow nguyenpanda's owl to be your steadfast companion on your intellectual odyssey.

🦢 swan
    Indulge in the beauty of aesthetics and user interfaces with the elegant swan package.
    Dive into the world of colors, front-end development, GUI, and more.
    Transform your applications into visual masterpieces with swan.

🐦‍⬛ raven
    Enter the realm of the raven, where intelligence and innovation
    converge in a comprehensive library of data structures
    Inspired by the ingenuity of the raven, this package offers elegant data structures classes.
"""

from .crow import *
from .butterfly import *
from .owl import *
from .swan import *

from .__version__ import __version__

VERSION = __version__

__all__ = (
    'crow',
    'butterfly',
    'owl',
    'raven',
    'swan',
)
