import base64
import io
from PIL import Image

dna_icon_b64 = b'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'

swap_b64 = b'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'

export_b64 = b'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'

chr_b64 = b'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'


def loadImage(Bytes):
    image = io.BytesIO(base64.b64decode(Bytes))
    image = Image.open(image)
    image.thumbnail((32, 32), Image.ANTIALIAS)
    return image


dna_icon = loadImage(dna_icon_b64)
swap = loadImage(swap_b64)
export = loadImage(export_b64)
chr_icon = loadImage(chr_b64)
