# -*- coding: utf-8 -*-
# Generated by Django 1.11.12 on 2019-06-28 18:12
from __future__ import unicode_literals

from django.db import migrations, models
import json_field.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DataLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('guid', models.CharField(max_length=64, verbose_name='Уникальный идентификатор записи')),
                ('timestamp', models.DateTimeField(auto_now_add=True, verbose_name='Время совершения действия')),
                ('event_type', models.CharField(db_index=True, max_length=256, verbose_name='Тип события')),
                ('event_code', models.CharField(db_index=True, max_length=32, verbose_name='Код события')),
                ('object_id', models.IntegerField(db_index=True, null=True, verbose_name='ID изменяемого объекта')),
                ('object_type', models.CharField(db_index=True, max_length=96, null=True, verbose_name='Имя модели объекта')),
                ('object_snapshot', json_field.fields.JSONField(default='{}', help_text='Enter a valid JSON object', null=True, verbose_name='Снимок состояния объекта')),
                ('verbose', models.TextField(db_index=True, verbose_name='Человекопонятное описание события')),
                ('system_type', models.CharField(max_length=32, verbose_name='Подсистема')),
                ('suid', models.IntegerField(db_index=True, null=True, verbose_name='Идентификатор объекта в подсистеме')),
                ('ip', models.CharField(db_index=True, max_length=15, verbose_name='IP адрес')),
                ('context_data', json_field.fields.JSONField(default='null', help_text='Enter a valid JSON object', null=True, verbose_name='Контекстно-зависимые данные')),
                ('request_token', models.CharField(max_length=64, verbose_name='Токен запроса')),
            ],
            options={
                'verbose_name': 'Журнал событий',
                'db_table': 'data_logging',
            },
        ),
    ]
