#!/usr/bin/env python3
"""
BeastX - Python Telegram Client Library
========================================

Credits:
    Original Telethon library by Lonami: https://github.com/LonamiWebs/Telethon
    BeastX Developer: t.me/GODMRUNAL
    Channel: @BEASTX_BOTS
    GitHub: github.com/beastx-python
"""

import re
from pathlib import Path
from setuptools import setup, find_packages

HERE = Path(__file__).parent

def get_version():
    """Read version from beastx/version.py"""
    version_file = HERE / 'beastx' / 'version.py'
    version_content = version_file.read_text()
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]", version_content, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")

def get_long_description():
    """Read the README.md file"""
    readme = HERE / 'README.md'
    if readme.exists():
        return readme.read_text(encoding='utf-8')
    return ''

setup(
    name='beastx-python',
    version=get_version(),
    description='Pure Python 3 MTProto API Telegram client library, for bots and users',
    long_description=get_long_description(),
    long_description_content_type='text/markdown',
    
    author='GODMRUNAL',
    author_email='contact@beastx.dev',
    
    url='https://github.com/beastx-python',
    download_url='https://github.com/beastx-python/archive/refs/tags/v1.0.3.tar.gz',
    
    project_urls={
        'Documentation': 'https://beastx-python.github.io',
        'Source': 'https://github.com/beastx-python',
        'Tracker': 'https://github.com/beastx-python/issues',
        'Telegram Channel': 'https://t.me/BEASTX_BOTS',
        'Developer': 'https://t.me/GODMRUNAL',
        'Original Telethon': 'https://github.com/LonamiWebs/Telethon',
    },
    
    license='MIT',
    
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Communications :: Chat',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        'Operating System :: OS Independent',
    ],
    
    keywords='telegram, telegram-client, mtproto, api, bot, asyncio, chat, messaging, beastx',
    
    packages=find_packages(exclude=['tests', 'tests.*', 'docs', 'docs.*', 'examples', 'examples.*']),
    
    python_requires='>=3.7',
    
    install_requires=[
        'pyaes>=1.6.1',
        'rsa>=4.7',
    ],
    
    extras_require={
        'cryptg': ['cryptg>=0.4.0'],
        'fast': ['cryptg>=0.4.0', 'hachoir>=3.1.3'],
        'docs': [
            'sphinx>=8.0.0',
            'sphinx-rtd-theme>=3.0.0',
        ],
        'dev': [
            'pytest>=9.0.0',
            'pytest-asyncio>=0.24.0',
            'rich>=14.0.0',
            'click>=8.0.0',
        ],
    },
    
    include_package_data=True,
    
    zip_safe=False,
    
    entry_points={
        'console_scripts': [
            'beastx=beastx.cli:main',
        ],
    },
)
