"""
Centralized prompts for PitchLense MCP Package.

This module contains all analysis prompts for different risk categories.
"""

from .risk_analysis_prompts import (
    CUSTOMER_RISK_PROMPT,
    OPERATIONAL_RISK_PROMPT,
    COMPETITIVE_RISK_PROMPT,
    EXIT_RISK_PROMPT,
    LEGAL_RISK_PROMPT,
    FINANCIAL_RISK_PROMPT,
    MARKET_RISK_PROMPT,
    PRODUCT_RISK_PROMPT,
    TEAM_RISK_PROMPT,
    UNSTRUCTURED_DATA_PROMPT,
    PEER_BENCHMARK_PROMPT,
    SOCIAL_COVERAGE_RISK_PROMPT
)

# DSPy-based prompts (optional - requires dspy-ai)
try:
    from .dspy_prompts import (
        create_all_risk_analyzers,
        create_optimized_analyzers,
        PromptOptimizer,
        RiskLevel,
        BenchmarkStatus,
        RiskIndicator,
        RiskAnalysisResult,
        PeerBenchmarkResult,
        CustomerRiskAnalyzer,
        OperationalRiskAnalyzer,
        CompetitiveRiskAnalyzer,
        ExitRiskAnalyzer,
        LegalRiskAnalyzer,
        FinancialRiskAnalyzer,
        MarketRiskAnalyzer,
        ProductRiskAnalyzer,
        TeamRiskAnalyzer,
        SocialCoverageRiskAnalyzer,
        PeerBenchmarkAnalyzer
    )
    DSPY_AVAILABLE = True
except ImportError:
    DSPY_AVAILABLE = False

__all__ = [
    "CUSTOMER_RISK_PROMPT",
    "OPERATIONAL_RISK_PROMPT", 
    "COMPETITIVE_RISK_PROMPT",
    "EXIT_RISK_PROMPT",
    "LEGAL_RISK_PROMPT",
    "FINANCIAL_RISK_PROMPT",
    "MARKET_RISK_PROMPT",
    "PRODUCT_RISK_PROMPT",
    "TEAM_RISK_PROMPT",
    "UNSTRUCTURED_DATA_PROMPT",
    "PEER_BENCHMARK_PROMPT",
    "SOCIAL_COVERAGE_RISK_PROMPT",
    "DSPY_AVAILABLE"
]

# Add DSPy components to __all__ if available
if DSPY_AVAILABLE:
    __all__.extend([
        "create_all_risk_analyzers",
        "create_optimized_analyzers", 
        "PromptOptimizer",
        "RiskLevel",
        "BenchmarkStatus",
        "RiskIndicator",
        "RiskAnalysisResult",
        "PeerBenchmarkResult",
        "CustomerRiskAnalyzer",
        "OperationalRiskAnalyzer",
        "CompetitiveRiskAnalyzer",
        "ExitRiskAnalyzer",
        "LegalRiskAnalyzer",
        "FinancialRiskAnalyzer",
        "MarketRiskAnalyzer",
        "ProductRiskAnalyzer",
        "TeamRiskAnalyzer",
        "SocialCoverageRiskAnalyzer",
        "PeerBenchmarkAnalyzer"
    ])
