from canvas_sdk.value_set.value_set import ValueSet


class Hcc005v1AnnualWellnessVisit(ValueSet):
    """Hcc005v1AnnualWellnessVisit."""

    VALUE_SET_NAME = "Annual Wellness Visit"

    HCPCS = {
        "G0438",
        "G0439",
        "G0402",
        "99387",
        "99397",
    }


class DysrhythmiaClassConditionSuspect(ValueSet):
    """Dysrhythmia Class Condition suspect."""

    VALUE_SET_NAME = "Dysrhythmia Class Condition suspect"
    EXPANSION_VERSION = "CanvasHCC Update 2024-11-04"

    ICD10CM = {
        "I420",
        "I421",
        "I422",
        "I423",
        "I424",
        "I425",
        "I426",
        "I427",
        "I428",
        "I429",
        "I470",
        "I471",
        "I4710",
        "I4711",
        "I4719",
        "I472",
        "I4720",
        "I4721",
        "I4729",
        "I479",
        "I480",
        "I481",
        "I4811",
        "I4819",
        "I482",
        "I4820",
        "I4821",
        "I483",
        "I484",
        "I4891",
        "I4892",
        "I4901",
        "I4902",
        "I491",
        "I492",
        "I493",
        "I4940",
        "I4949",
        "I495",
        "I498",
        "I499",
    }


class Antiarrhythmics(ValueSet):
    """Antiarrhythmic medications."""

    VALUE_SET_NAME = "Antiarrhythmics"
    EXPANSION_VERSION = "ClassPath Update 18-10-15"

    FDB = {
        "150358",
        "151807",
        "152779",
        "155773",
        "157601",
        "160121",
        "165621",
        "166591",
        "169107",
        "169508",
        "170461",
        "174429",
        "175363",
        "175494",
        "178251",
        "183239",
        "184929",
        "185830",
        "189377",
        "189730",
        "190878",
        "193821",
        "194412",
        "195187",
        "196380",
        "198310",
        "199400",
        "203114",
        "205183",
        "206598",
        "208686",
        "210260",
        "210732",
        "212898",
        "221901",
        "222092",
        "223459",
        "224332",
        "228864",
        "230155",
        "237183",
        "243776",
        "248491",
        "248829",
        "250272",
        "251530",
        "251766",
        "260972",
        "261266",
        "261929",
        "262594",
        "265464",
        "265785",
        "274471",
        "278255",
        "280333",
        "281153",
        "283306",
        "288964",
        "291187",
        "296991",
        "444249",
        "444944",
        "449494",
        "449496",
        "451558",
        "451559",
        "451560",
        "453457",
        "453462",
        "454178",
        "454180",
        "454181",
        "454205",
        "454206",
        "454207",
        "454371",
        "545231",
        "545232",
        "545233",
        "545238",
        "545239",
        "558741",
        "558745",
        "559416",
        "560050",
        "563304",
        "563305",
        "563306",
        "563310",
        "564459",
        "564460",
        "565068",
        "565069",
        "573523",
        "583982",
        "583985",
        "590326",
        "590375",
        "590376",
        "591479",
        "592349",
        "592421",
        "594710",
        "594714",
    }


class LabReportCreatinine(ValueSet):
    """LabReportCreatinine."""

    VALUE_SET_NAME = "Lab Report Creatinine"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-04"

    LOINC = {
        "2160-0",
    }


class HypertensiveChronicKidneyDisease(ValueSet):
    """
    **Clinical Focus:** This value set contains concepts that represent hypertensive kidney disease.

    **Data Element Scope:** This value set may use the Quality Data Model (QDM) category related to Diagnosis.

    **Inclusion Criteria:** Includes only relevant concepts associated with hypertensive kidney disease.

    **Exclusion Criteria:** No exclusions.
    """

    OID = "2.16.840.1.113883.3.464.1003.109.12.1017"
    VALUE_SET_NAME = "Hypertensive Chronic Kidney Disease"
    EXPANSION_VERSION = "eCQM Update 2020-05-07"

    ICD10CM = {"I120", "I129", "I130", "I1310", "I1311", "I132", "I150", "I151"}

    ICD9CM = {
        "40301",
        "40310",
        "40311",
        "40390",
        "40391",
        "40400",
        "40401",
        "40402",
        "40403",
        "40410",
        "40411",
        "40412",
        "40413",
        "40490",
        "40491",
        "40492",
        "40493",
    }

    SNOMEDCT = {
        "111438007",
        "123799005",
        "123800009",
        "14973001",
        "193003",
        "194774006",
        "194783001",
        "19769006",
        "23130000",
        "28119000",
        "285831000119108",
        "285841000119104",
        "286371000119107",
        "32916005",
        "38481006",
        "39018007",
        "397748008",
        "427889009",
        "428575007",
        "473392002",
        "49220004",
        "57684003",
        "62240004",
        "65443008",
        "66052004",
        "66610008",
        "73410007",
        "78544004",
        "81363003",
        "86234004",
        "90493000",
    }


class DiabetesWithoutComplication(ValueSet):
    """Diabetes Without Complication."""

    VALUE_SET_NAME = "Diabetes Without Complication"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-16"

    ICD10CM = {
        "E119",
    }


class DiabetesEyeConditionSuspect(ValueSet):
    """Diabetes Eye Condition suspect."""

    VALUE_SET_NAME = "Diabetes Eye Condition suspect"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-16"

    ICD10CM = {
        "H28",
        "H36",
    }


class DiabetesEyeClassConditionSuspect(ValueSet):
    """Diabetes Eye Class Condition suspect."""

    VALUE_SET_NAME = "Diabetes Eye Class Condition suspect"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-16"

    ICD10CM = {
        "H3500",
        "H35011",
        "H35012",
        "H35013",
        "H35019",
        "H35021",
        "H35022",
        "H35023",
        "H35029",
        "H35031",
        "H35032",
        "H35033",
        "H35039",
        "H35041",
        "H35042",
        "H35043",
        "H35049",
        "H35051",
        "H35052",
        "H35053",
        "H35059",
        "H35061",
        "H35062",
        "H35063",
        "H35069",
        "H35071",
        "H35072",
        "H35073",
        "H35079",
        "H3509",
        "H35101",
        "H35102",
        "H35103",
        "H35109",
        "H35111",
        "H35112",
        "H35113",
        "H35119",
        "H35121",
        "H35122",
        "H35123",
        "H35129",
        "H35131",
        "H35132",
        "H35133",
        "H35139",
        "H35141",
        "H35142",
        "H35143",
        "H35149",
        "H35151",
        "H35152",
        "H35153",
        "H35159",
        "H35161",
        "H35162",
        "H35163",
        "H35169",
        "H35171",
        "H35172",
        "H35173",
        "H35179",
        "H3520",
        "H3521",
        "H3522",
        "H3523",
        "H3530",
        "H3531",
        "H353110",
        "H353111",
        "H353112",
        "H353113",
        "H353114",
        "H353120",
        "H353121",
        "H353122",
        "H353123",
        "H353124",
        "H353130",
        "H353131",
        "H353132",
        "H353133",
        "H353134",
        "H353190",
        "H353191",
        "H353192",
        "H353193",
        "H353194",
        "H3532",
        "H353210",
        "H353211",
        "H353212",
        "H353213",
        "H353220",
        "H353221",
        "H353222",
        "H353223",
        "H353230",
        "H353231",
        "H353232",
        "H353233",
        "H353290",
        "H353291",
        "H353292",
        "H353293",
        "H3533",
        "H35341",
        "H35342",
        "H35343",
        "H35349",
        "H35351",
        "H35352",
        "H35353",
        "H35359",
        "H35361",
        "H35362",
        "H35363",
        "H35369",
        "H35371",
        "H35372",
        "H35373",
        "H35379",
        "H35381",
        "H35382",
        "H35383",
        "H35389",
        "H3540",
        "H35411",
        "H35412",
        "H35413",
        "H35419",
        "H35421",
        "H35422",
        "H35423",
        "H35429",
        "H35431",
        "H35432",
        "H35433",
        "H35439",
        "H35441",
        "H35442",
        "H35443",
        "H35449",
        "H35451",
        "H35452",
        "H35453",
        "H35459",
        "H35461",
        "H35462",
        "H35463",
        "H35469",
        "H3550",
        "H3551",
        "H3552",
        "H3553",
        "H3554",
        "H3560",
        "H3561",
        "H3562",
        "H3563",
        "H3570",
        "H35711",
        "H35712",
        "H35713",
        "H35719",
        "H35721",
        "H35722",
        "H35723",
        "H35729",
        "H35731",
        "H35732",
        "H35733",
        "H35739",
        "H3581",
        "H3582",
        "H3589",
        "H359",
    }


class DiabetesNeurologicConditionSuspect(ValueSet):
    """Diabetes Neurologic Condition suspect."""

    VALUE_SET_NAME = "Diabetes Neurologic Condition suspect"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-16"

    ICD10CM = {
        "G63",
        "G737",
        "G53",
    }


class DiabetesRenalConditionSuspect(ValueSet):
    """Diabetes Renal Condition suspect."""

    VALUE_SET_NAME = "Diabetes Renal Condition suspect"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-16"

    ICD10CM = {
        "N181",
        "N182",
        "N183",
        "N184",
        "N185",
        "N186",
        "N189",
    }


class DiabetesCirculatoryClassConditionSuspect(ValueSet):
    """Diabetes Circulatory Class Condition suspect."""

    VALUE_SET_NAME = "Diabetes Circulatory Class Condition suspect"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-16"

    ICD10CM = {
        "I7300",
        "I7301",
        "I731",
        "I7381",
        "I7389",
        "I739",
        "I700",
        "I701",
        "I70201",
        "I70202",
        "I70203",
        "I70208",
        "I70209",
        "I70211",
        "I70212",
        "I70213",
        "I70218",
        "I70219",
        "I70221",
        "I70222",
        "I70223",
        "I70228",
        "I70229",
        "I70231",
        "I70232",
        "I70233",
        "I70234",
        "I70235",
        "I70238",
        "I70239",
        "I70241",
        "I70242",
        "I70243",
        "I70244",
        "I70245",
        "I70248",
        "I70249",
        "I7025",
        "I70261",
        "I70262",
        "I70263",
        "I70268",
        "I70269",
        "I70291",
        "I70292",
        "I70293",
        "I70298",
        "I70299",
        "I70301",
        "I70302",
        "I70303",
        "I70308",
        "I70309",
        "I70311",
        "I70312",
        "I70313",
        "I70318",
        "I70319",
        "I70321",
        "I70322",
        "I70323",
        "I70328",
        "I70329",
        "I70331",
        "I70332",
        "I70333",
        "I70334",
        "I70335",
        "I70338",
        "I70339",
        "I70341",
        "I70342",
        "I70343",
        "I70344",
        "I70345",
        "I70348",
        "I70349",
        "I7035",
        "I70361",
        "I70362",
        "I70363",
        "I70368",
        "I70369",
        "I70391",
        "I70392",
        "I70393",
        "I70398",
        "I70399",
        "I70401",
        "I70402",
        "I70403",
        "I70408",
        "I70409",
        "I70411",
        "I70412",
        "I70413",
        "I70418",
        "I70419",
        "I70421",
        "I70422",
        "I70423",
        "I70428",
        "I70429",
        "I70431",
        "I70432",
        "I70433",
        "I70434",
        "I70435",
        "I70438",
        "I70439",
        "I70441",
        "I70442",
        "I70443",
        "I70444",
        "I70445",
        "I70448",
        "I70449",
        "I7045",
        "I70461",
        "I70462",
        "I70463",
        "I70468",
        "I70469",
        "I70491",
        "I70492",
        "I70493",
        "I70498",
        "I70499",
        "I70501",
        "I70502",
        "I70503",
        "I70508",
        "I70509",
        "I70511",
        "I70512",
        "I70513",
        "I70518",
        "I70519",
        "I70521",
        "I70522",
        "I70523",
        "I70528",
        "I70529",
        "I70531",
        "I70532",
        "I70533",
        "I70534",
        "I70535",
        "I70538",
        "I70539",
        "I70541",
        "I70542",
        "I70543",
        "I70544",
        "I70545",
        "I70548",
        "I70549",
        "I7055",
        "I70561",
        "I70562",
        "I70563",
        "I70568",
        "I70569",
        "I70591",
        "I70592",
        "I70593",
        "I70598",
        "I70599",
        "I70601",
        "I70602",
        "I70603",
        "I70608",
        "I70609",
        "I70611",
        "I70612",
        "I70613",
        "I70618",
        "I70619",
        "I70621",
        "I70622",
        "I70623",
        "I70628",
        "I70629",
        "I70631",
        "I70632",
        "I70633",
        "I70634",
        "I70635",
        "I70638",
        "I70639",
        "I70641",
        "I70642",
        "I70643",
        "I70644",
        "I70645",
        "I70648",
        "I70649",
        "I7065",
        "I70661",
        "I70662",
        "I70663",
        "I70668",
        "I70669",
        "I70691",
        "I70692",
        "I70693",
        "I70698",
        "I70699",
        "I70701",
        "I70702",
        "I70703",
        "I70708",
        "I70709",
        "I70711",
        "I70712",
        "I70713",
        "I70718",
        "I70719",
        "I70721",
        "I70722",
        "I70723",
        "I70728",
        "I70729",
        "I70731",
        "I70732",
        "I70733",
        "I70734",
        "I70735",
        "I70738",
        "I70739",
        "I70741",
        "I70742",
        "I70743",
        "I70744",
        "I70745",
        "I70748",
        "I70749",
        "I7075",
        "I70761",
        "I70762",
        "I70763",
        "I70768",
        "I70769",
        "I70791",
        "I70792",
        "I70793",
        "I70798",
        "I70799",
        "I708",
        "I7090",
        "I7091",
        "I7092",
        "I7100",
        "I7101",
        "I71010",
        "I71011",
        "I71012",
        "I71019",
        "I7102",
        "I7103",
        "I711",
        "I7110",
        "I7111",
        "I7112",
        "I7113",
        "I712",
        "I7120",
        "I7121",
        "I7122",
        "I7123",
        "I713",
        "I7130",
        "I7131",
        "I7132",
        "I7133",
        "I714",
        "I7140",
        "I7141",
        "I7142",
        "I7143",
        "I715",
        "I7150",
        "I7151",
        "I7152",
        "I716",
        "I7160",
        "I7161",
        "I7162",
        "I718",
        "I719",
        "I790",
        "I791",
        "I798",
    }


class DiabetesOtherClassConditionSuspect(ValueSet):
    """Diabetes Other Class Condition suspect."""

    VALUE_SET_NAME = "Diabetes Other Class Condition suspect"
    EXPANSION_VERSION = "CanvasHCC Update 2018-10-16"

    ICD10CM = {
        "M1460",
        "M14611",
        "M14612",
        "M14619",
        "M14621",
        "M14622",
        "M14629",
        "M14631",
        "M14632",
        "M14639",
        "M14641",
        "M14642",
        "M14649",
        "M14651",
        "M14652",
        "M14659",
        "M14661",
        "M14662",
        "M14669",
        "M14671",
        "M14672",
        "M14679",
        "M1468",
        "M1469",
        "M1480",
        "M14811",
        "M14812",
        "M14819",
        "M14821",
        "M14822",
        "M14829",
        "M14831",
        "M14832",
        "M14839",
        "M14841",
        "M14842",
        "M14849",
        "M14851",
        "M14852",
        "M14859",
        "M14861",
        "M14862",
        "M14869",
        "M14871",
        "M14872",
        "M14879",
        "M1488",
        "M1489",
        "L97101",
        "L97102",
        "L97103",
        "L97104",
        "L97105",
        "L97106",
        "L97108",
        "L97109",
        "L97111",
        "L97112",
        "L97113",
        "L97114",
        "L97115",
        "L97116",
        "L97118",
        "L97119",
        "L97121",
        "L97122",
        "L97123",
        "L97124",
        "L97125",
        "L97126",
        "L97128",
        "L97129",
        "L97201",
        "L97202",
        "L97203",
        "L97204",
        "L97205",
        "L97206",
        "L97208",
        "L97209",
        "L97211",
        "L97212",
        "L97213",
        "L97214",
        "L97215",
        "L97216",
        "L97218",
        "L97219",
        "L97221",
        "L97222",
        "L97223",
        "L97224",
        "L97225",
        "L97226",
        "L97228",
        "L97229",
        "L97301",
        "L97302",
        "L97303",
        "L97304",
        "L97305",
        "L97306",
        "L97308",
        "L97309",
        "L97311",
        "L97312",
        "L97313",
        "L97314",
        "L97315",
        "L97316",
        "L97318",
        "L97319",
        "L97321",
        "L97322",
        "L97323",
        "L97324",
        "L97325",
        "L97326",
        "L97328",
        "L97329",
        "L97401",
        "L97402",
        "L97403",
        "L97404",
        "L97405",
        "L97406",
        "L97408",
        "L97409",
        "L97411",
        "L97412",
        "L97413",
        "L97414",
        "L97415",
        "L97416",
        "L97418",
        "L97419",
        "L97421",
        "L97422",
        "L97423",
        "L97424",
        "L97425",
        "L97426",
        "L97428",
        "L97429",
        "L97501",
        "L97502",
        "L97503",
        "L97504",
        "L97505",
        "L97506",
        "L97508",
        "L97509",
        "L97511",
        "L97512",
        "L97513",
        "L97514",
        "L97515",
        "L97516",
        "L97518",
        "L97519",
        "L97521",
        "L97522",
        "L97523",
        "L97524",
        "L97525",
        "L97526",
        "L97528",
        "L97529",
        "L97801",
        "L97802",
        "L97803",
        "L97804",
        "L97805",
        "L97806",
        "L97808",
        "L97809",
        "L97811",
        "L97812",
        "L97813",
        "L97814",
        "L97815",
        "L97816",
        "L97818",
        "L97819",
        "L97821",
        "L97822",
        "L97823",
        "L97824",
        "L97825",
        "L97826",
        "L97828",
        "L97829",
        "L97901",
        "L97902",
        "L97903",
        "L97904",
        "L97905",
        "L97906",
        "L97908",
        "L97909",
        "L97911",
        "L97912",
        "L97913",
        "L97914",
        "L97915",
        "L97916",
        "L97918",
        "L97919",
        "L97921",
        "L97922",
        "L97923",
        "L97924",
        "L97925",
        "L97926",
        "L97928",
        "L97929",
        "L98411",
        "L98412",
        "L98413",
        "L98414",
        "L98415",
        "L98416",
        "L98418",
        "L98419",
        "L98421",
        "L98422",
        "L98423",
        "L98424",
        "L98425",
        "L98426",
        "L98428",
        "L98429",
        "L98491",
        "L98492",
        "L98493",
        "L98494",
        "L98495",
        "L98496",
        "L98498",
        "L98499",
    }


__exports__ = (
    "Antiarrhythmics",
    "DiabetesCirculatoryClassConditionSuspect",
    "DiabetesEyeClassConditionSuspect",
    "DiabetesEyeConditionSuspect",
    "DiabetesNeurologicConditionSuspect",
    "DiabetesOtherClassConditionSuspect",
    "DiabetesRenalConditionSuspect",
    "DiabetesWithoutComplication",
    "DysrhythmiaClassConditionSuspect",
    "Hcc005v1AnnualWellnessVisit",
    "HypertensiveChronicKidneyDisease",
    "LabReportCreatinine",
)
