import { ApiObject, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
/**
 *
 *
 * @schema GrafanaDashboard
 */
export declare class GrafanaDashboard extends ApiObject {
    /**
     * Returns the apiVersion and kind for "GrafanaDashboard"
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "GrafanaDashboard".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props
     */
    static manifest(props?: GrafanaDashboardProps): any;
    /**
     * Defines a "GrafanaDashboard" API object
     * @param scope the scope in which to define this object
     * @param id a scope-local name for the object
     * @param props initialization props
     */
    constructor(scope: Construct, id: string, props?: GrafanaDashboardProps);
}
/**
 * @schema GrafanaDashboard
 */
export interface GrafanaDashboardProps {
    /**
     * @schema GrafanaDataSource#metadata
     */
    readonly metadata?: any;
    /**
     * @schema GrafanaDashboard#spec
     */
    readonly spec?: GrafanaDashboardSpec;
}
/**
 * @schema GrafanaDashboardSpec
 */
export interface GrafanaDashboardSpec {
    /**
     * @schema GrafanaDashboardSpec#name
     */
    readonly name?: string;
    /**
     * @schema GrafanaDashboardSpec#json
     */
    readonly json?: string;
    /**
     * Jsonnet source. Has access to grafonnet.
     *
     * @schema GrafanaDashboardSpec#jsonnet
     */
    readonly jsonnet?: string;
    /**
     * URL to dashboard json
     *
     * @schema GrafanaDashboardSpec#url
     */
    readonly url?: string;
    /**
     * @schema GrafanaDashboardSpec#datasources
     */
    readonly datasources?: any[];
    /**
     * @schema GrafanaDashboardSpec#plugins
     */
    readonly plugins?: any[];
    /**
     * Folder name that this dashboard will be assigned to.
     *
     * @schema GrafanaDashboardSpec#customFolderName
     */
    readonly customFolderName?: string;
}
