# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Image(pulumi.CustomResource):
    archive_size_bytes: pulumi.Output[float]
    creation_timestamp: pulumi.Output[str]
    description: pulumi.Output[str]
    disk_size_gb: pulumi.Output[float]
    family: pulumi.Output[str]
    label_fingerprint: pulumi.Output[str]
    labels: pulumi.Output[dict]
    licenses: pulumi.Output[list]
    name: pulumi.Output[str]
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    raw_disk: pulumi.Output[dict]
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    source_disk: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, description=None, disk_size_gb=None, family=None, labels=None, licenses=None, name=None, project=None, raw_disk=None, source_disk=None, __name__=None, __opts__=None):
        """
        Represents an Image resource.
        
        Google Compute Engine uses operating system images to create the root
        persistent disks for your instances. You specify an image when you create
        an instance. Images contain a boot loader, an operating system, and a
        root file system. Linux operating system images are also capable of
        running containers on Compute Engine.
        
        Images can be either public or custom.
        
        Public images are provided and maintained by Google, open-source
        communities, and third-party vendors. By default, all projects have
        access to these images and can use them to create instances.  Custom
        images are available only to your project. You can create a custom image
        from root persistent disks and other images. Then, use the custom image
        to create an instance.
        
        
        To get more information about Image, see:
        
        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/images)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/images)
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_image.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['description'] = description

        __props__['disk_size_gb'] = disk_size_gb

        __props__['family'] = family

        __props__['labels'] = labels

        __props__['licenses'] = licenses

        __props__['name'] = name

        __props__['project'] = project

        __props__['raw_disk'] = raw_disk

        __props__['source_disk'] = source_disk

        __props__['archive_size_bytes'] = None
        __props__['creation_timestamp'] = None
        __props__['label_fingerprint'] = None
        __props__['self_link'] = None

        super(Image, __self__).__init__(
            'gcp:compute/image:Image',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

