# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class RouterPeer(pulumi.CustomResource):
    advertised_route_priority: pulumi.Output[float]
    """
    The priority of routes advertised to this BGP peer.
    Changing this forces a new peer to be created.
    """
    interface: pulumi.Output[str]
    """
    The name of the interface the BGP peer is associated with.
    Changing this forces a new peer to be created.
    """
    ip_address: pulumi.Output[str]
    """
    IP address of the interface inside Google Cloud Platform.
    """
    name: pulumi.Output[str]
    """
    A unique name for BGP peer, required by GCE. Changing
    this forces a new peer to be created.
    """
    peer_asn: pulumi.Output[float]
    """
    Peer BGP Autonomous System Number (ASN).
    Changing this forces a new peer to be created.
    """
    peer_ip_address: pulumi.Output[str]
    """
    IP address of the BGP interface outside Google Cloud.
    Changing this forces a new peer to be created.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which this peer's router belongs. If it
    is not provided, the provider project is used. Changing this forces a new peer to be created.
    """
    region: pulumi.Output[str]
    """
    The region this peer's router sits in. If not specified,
    the project region will be used. Changing this forces a new peer to be
    created.
    """
    router: pulumi.Output[str]
    """
    The name of the router in which this BGP peer will be configured.
    Changing this forces a new peer to be created.
    """
    def __init__(__self__, resource_name, opts=None, advertised_route_priority=None, interface=None, name=None, peer_asn=None, peer_ip_address=None, project=None, region=None, router=None, __name__=None, __opts__=None):
        """
        Manages a Cloud Router BGP peer. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/cloudrouter)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/routers).
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Changing this forces a new peer to be created.
        :param pulumi.Input[str] interface: The name of the interface the BGP peer is associated with.
               Changing this forces a new peer to be created.
        :param pulumi.Input[str] name: A unique name for BGP peer, required by GCE. Changing
               this forces a new peer to be created.
        :param pulumi.Input[float] peer_asn: Peer BGP Autonomous System Number (ASN).
               Changing this forces a new peer to be created.
        :param pulumi.Input[str] peer_ip_address: IP address of the BGP interface outside Google Cloud.
               Changing this forces a new peer to be created.
        :param pulumi.Input[str] project: The ID of the project in which this peer's router belongs. If it
               is not provided, the provider project is used. Changing this forces a new peer to be created.
        :param pulumi.Input[str] region: The region this peer's router sits in. If not specified,
               the project region will be used. Changing this forces a new peer to be
               created.
        :param pulumi.Input[str] router: The name of the router in which this BGP peer will be configured.
               Changing this forces a new peer to be created.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_router_peer.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['advertised_route_priority'] = advertised_route_priority

        if interface is None:
            raise TypeError("Missing required property 'interface'")
        __props__['interface'] = interface

        __props__['name'] = name

        if peer_asn is None:
            raise TypeError("Missing required property 'peer_asn'")
        __props__['peer_asn'] = peer_asn

        __props__['peer_ip_address'] = peer_ip_address

        __props__['project'] = project

        __props__['region'] = region

        if router is None:
            raise TypeError("Missing required property 'router'")
        __props__['router'] = router

        __props__['ip_address'] = None

        super(RouterPeer, __self__).__init__(
            'gcp:compute/routerPeer:RouterPeer',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

