# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Snapshot(pulumi.CustomResource):
    creation_timestamp: pulumi.Output[str]
    description: pulumi.Output[str]
    disk_size_gb: pulumi.Output[float]
    label_fingerprint: pulumi.Output[str]
    labels: pulumi.Output[dict]
    licenses: pulumi.Output[list]
    name: pulumi.Output[str]
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs.
    If it is not provided, the provider project is used.
    """
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    snapshot_encryption_key: pulumi.Output[dict]
    snapshot_id: pulumi.Output[float]
    source_disk: pulumi.Output[str]
    source_disk_encryption_key: pulumi.Output[dict]
    source_disk_link: pulumi.Output[str]
    storage_bytes: pulumi.Output[float]
    zone: pulumi.Output[str]
    def __init__(__self__, resource_name, opts=None, description=None, labels=None, name=None, project=None, snapshot_encryption_key=None, source_disk=None, source_disk_encryption_key=None, zone=None, __name__=None, __opts__=None):
        """
        Represents a Persistent Disk Snapshot resource.
        
        Use snapshots to back up data from your persistent disks. Snapshots are
        different from public images and custom images, which are used primarily
        to create instances or configure instance templates. Snapshots are useful
        for periodic backup of the data on your persistent disks. You can create
        snapshots from persistent disks even while they are attached to running
        instances.
        
        Snapshots are incremental, so you can create regular snapshots on a
        persistent disk faster and at a much lower cost than if you regularly
        created a full image of the disk.
        
        
        To get more information about Snapshot, see:
        
        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/snapshots)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/disks/create-snapshots)
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/compute_snapshot.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['description'] = description

        __props__['labels'] = labels

        __props__['name'] = name

        __props__['project'] = project

        __props__['snapshot_encryption_key'] = snapshot_encryption_key

        if source_disk is None:
            raise TypeError("Missing required property 'source_disk'")
        __props__['source_disk'] = source_disk

        __props__['source_disk_encryption_key'] = source_disk_encryption_key

        __props__['zone'] = zone

        __props__['creation_timestamp'] = None
        __props__['disk_size_gb'] = None
        __props__['label_fingerprint'] = None
        __props__['licenses'] = None
        __props__['self_link'] = None
        __props__['snapshot_id'] = None
        __props__['source_disk_link'] = None
        __props__['storage_bytes'] = None

        super(Snapshot, __self__).__init__(
            'gcp:compute/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

