# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Project(pulumi.CustomResource):
    auto_create_network: pulumi.Output[bool]
    """
    Create the 'default' network automatically.  Default `true`.
    If set to `false`, the default network will be deleted.  Note that, for quota purposes, you
    will still need to have 1 network slot available to create the project succesfully, even if
    you set `auto_create_network` to `false`, since the network will exist momentarily.
    """
    billing_account: pulumi.Output[str]
    folder_id: pulumi.Output[str]
    """
    The numeric ID of the folder this project should be
    created under. Only one of `org_id` or `folder_id` may be
    specified. If the `folder_id` is specified, then the project is
    created under the specified folder. Changing this forces the
    project to be migrated to the newly specified folder.
    """
    labels: pulumi.Output[dict]
    """
    A set of key/value label pairs to assign to the project.
    """
    name: pulumi.Output[str]
    """
    The display name of the project.
    """
    number: pulumi.Output[str]
    """
    The numeric identifier of the project.
    """
    org_id: pulumi.Output[str]
    """
    The numeric ID of the organization this project belongs to.
    Changing this forces a new project to be created.  Only one of
    `org_id` or `folder_id` may be specified. If the `org_id` is
    specified then the project is created at the top level. Changing
    this forces the project to be migrated to the newly specified
    organization.
    """
    project_id: pulumi.Output[str]
    """
    The project ID. Changing this forces a new project to be created.
    """
    skip_delete: pulumi.Output[bool]
    def __init__(__self__, resource_name, opts=None, auto_create_network=None, billing_account=None, folder_id=None, labels=None, name=None, org_id=None, project_id=None, skip_delete=None, __name__=None, __opts__=None):
        """
        Create a Project resource with the given unique name, props, and options.
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_create_network: Create the 'default' network automatically.  Default `true`.
               If set to `false`, the default network will be deleted.  Note that, for quota purposes, you
               will still need to have 1 network slot available to create the project succesfully, even if
               you set `auto_create_network` to `false`, since the network will exist momentarily.
        :param pulumi.Input[str] folder_id: The numeric ID of the folder this project should be
               created under. Only one of `org_id` or `folder_id` may be
               specified. If the `folder_id` is specified, then the project is
               created under the specified folder. Changing this forces the
               project to be migrated to the newly specified folder.
        :param pulumi.Input[dict] labels: A set of key/value label pairs to assign to the project.
        :param pulumi.Input[str] name: The display name of the project.
        :param pulumi.Input[str] org_id: The numeric ID of the organization this project belongs to.
               Changing this forces a new project to be created.  Only one of
               `org_id` or `folder_id` may be specified. If the `org_id` is
               specified then the project is created at the top level. Changing
               this forces the project to be migrated to the newly specified
               organization.
        :param pulumi.Input[str] project_id: The project ID. Changing this forces a new project to be created.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/project.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['auto_create_network'] = auto_create_network

        __props__['billing_account'] = billing_account

        __props__['folder_id'] = folder_id

        __props__['labels'] = labels

        __props__['name'] = name

        __props__['org_id'] = org_id

        if project_id is None:
            raise TypeError("Missing required property 'project_id'")
        __props__['project_id'] = project_id

        __props__['skip_delete'] = skip_delete

        __props__['number'] = None

        super(Project, __self__).__init__(
            'gcp:organizations/project:Project',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

