# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class Database(pulumi.CustomResource):
    charset: pulumi.Output[str]
    """
    The charset value. See MySQL's
    [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
    and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
    for more details and supported values. Postgres databases are in beta
    and have limited `charset` support; they only support a value of `UTF8` at creation time.
    """
    collation: pulumi.Output[str]
    """
    The collation value. See MySQL's
    [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
    and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
    for more details and supported values. Postgres databases are in beta
    and have limited `collation` support; they only support a value of `en_US.UTF8` at creation time.
    """
    instance: pulumi.Output[str]
    """
    The name of containing instance.
    """
    name: pulumi.Output[str]
    """
    The name of the database.
    """
    project: pulumi.Output[str]
    """
    The ID of the project in which the resource belongs. If it
    is not provided, the provider project is used.
    """
    self_link: pulumi.Output[str]
    """
    The URI of the created resource.
    """
    def __init__(__self__, resource_name, opts=None, charset=None, collation=None, instance=None, name=None, project=None, __name__=None, __opts__=None):
        """
        Creates a new Google SQL Database on a Google SQL Database Instance. For more information, see
        the [official documentation](https://cloud.google.com/sql/),
        or the [JSON API](https://cloud.google.com/sql/docs/admin-api/v1beta4/databases).
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] charset: The charset value. See MySQL's
               [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
               and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
               for more details and supported values. Postgres databases are in beta
               and have limited `charset` support; they only support a value of `UTF8` at creation time.
        :param pulumi.Input[str] collation: The collation value. See MySQL's
               [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
               and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
               for more details and supported values. Postgres databases are in beta
               and have limited `collation` support; they only support a value of `en_US.UTF8` at creation time.
        :param pulumi.Input[str] instance: The name of containing instance.
        :param pulumi.Input[str] name: The name of the database.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/sql_database.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['charset'] = charset

        __props__['collation'] = collation

        if instance is None:
            raise TypeError("Missing required property 'instance'")
        __props__['instance'] = instance

        __props__['name'] = name

        __props__['project'] = project

        __props__['self_link'] = None

        super(Database, __self__).__init__(
            'gcp:sql/database:Database',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

