# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from .. import utilities, tables

class TransferJob(pulumi.CustomResource):
    creation_time: pulumi.Output[str]
    """
    When the Transfer Job was created.
    """
    deletion_time: pulumi.Output[str]
    """
    When the Transfer Job was deleted.
    """
    description: pulumi.Output[str]
    """
    Unique description to identify the Transfer Job.
    """
    last_modification_time: pulumi.Output[str]
    """
    When the Transfer Job was last modified.
    """
    name: pulumi.Output[str]
    """
    The name of the Transfer Job.
    """
    project: pulumi.Output[str]
    """
    The project in which the resource belongs. If it
    is not provided, the provider project is used.
    """
    schedule: pulumi.Output[dict]
    """
    Schedule specification defining when the Transfer Job should be scheduled to start, end and and what time to run. Structure documented below.
    """
    status: pulumi.Output[str]
    """
    Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
    """
    transfer_spec: pulumi.Output[dict]
    """
    Transfer specification. Structure documented below.
    """
    def __init__(__self__, resource_name, opts=None, description=None, project=None, schedule=None, status=None, transfer_spec=None, __name__=None, __opts__=None):
        """
        Creates a new Transfer Job in Google Cloud Storage Transfer.
        
        To get more information about Google Cloud Storage Transfer, see:
        
        * [Overview](https://cloud.google.com/storage-transfer/docs/overview)
        * [API documentation](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/transferJobs#TransferJob)
        * How-to Guides
            * [Configuring Access to Data Sources and Sinks](https://cloud.google.com/storage-transfer/docs/configure-access)
        
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Unique description to identify the Transfer Job.
        :param pulumi.Input[str] project: The project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[dict] schedule: Schedule specification defining when the Transfer Job should be scheduled to start, end and and what time to run. Structure documented below.
        :param pulumi.Input[str] status: Status of the job. Default: `ENABLED`. **NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.**
        :param pulumi.Input[dict] transfer_spec: Transfer specification. Structure documented below.

        > This content is derived from https://github.com/terraform-providers/terraform-provider-google/blob/master/website/docs/r/storage_transfer_job.html.markdown.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if not resource_name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(resource_name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if description is None:
            raise TypeError("Missing required property 'description'")
        __props__['description'] = description

        __props__['project'] = project

        if schedule is None:
            raise TypeError("Missing required property 'schedule'")
        __props__['schedule'] = schedule

        __props__['status'] = status

        if transfer_spec is None:
            raise TypeError("Missing required property 'transfer_spec'")
        __props__['transfer_spec'] = transfer_spec

        __props__['creation_time'] = None
        __props__['deletion_time'] = None
        __props__['last_modification_time'] = None
        __props__['name'] = None

        super(TransferJob, __self__).__init__(
            'gcp:storage/transferJob:TransferJob',
            resource_name,
            __props__,
            opts)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

