# mypy-boto3-emr

Mypy-friendly auto-generated type annotations for `boto3 emr 1.10.34` service.
More information can be found [here](https://github.com/vemel/mypy_boto3).

- [mypy-boto3-emr](#mypy-boto3-emr)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `emr` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-emr]

# build service index. You should execute this command everytime
# you update boto3-stubs or install/remove services
python -m python -m mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking.

```python
import boto3

from mypy_boto3 import emr
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_emr as emr

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("emr")
client: emr.Client = boto3.client("emr")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: emr.Client = session.client("emr")


# Waiters need type annotation on creation
cluster_running_waiter: emr.ClusterRunningWaiter = client.get_waiter("cluster_running")
cluster_terminated_waiter: emr.ClusterTerminatedWaiter = client.get_waiter("cluster_terminated")
step_complete_waiter: emr.StepCompleteWaiter = client.get_waiter("step_complete")

# Paginators need type annotation on creation
list_bootstrap_actions_paginator: emr.ListBootstrapActionsPaginator = client.get_paginator("list_bootstrap_actions")
list_clusters_paginator: emr.ListClustersPaginator = client.get_paginator("list_clusters")
list_instance_fleets_paginator: emr.ListInstanceFleetsPaginator = client.get_paginator("list_instance_fleets")
list_instance_groups_paginator: emr.ListInstanceGroupsPaginator = client.get_paginator("list_instance_groups")
list_instances_paginator: emr.ListInstancesPaginator = client.get_paginator("list_instances")
list_security_configurations_paginator: emr.ListSecurityConfigurationsPaginator = client.get_paginator("list_security_configurations")
list_steps_paginator: emr.ListStepsPaginator = client.get_paginator("list_steps")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- Latest version of `boto3` is used.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from latest documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Code is processed by [black](https://github.com/psf/black) for readability.

## Submodules

- `master` - Install `mypy-boto3` package.