import glob
import os
from pathlib import Path
from agentmake import config, PACKAGE_PATH

class BibleBooks:

    # Map of all Bible abbreviations
    abbrev = {}
    booksMap = {}
    initialized = False

    # English abbreviations according to SBL-style
    # http://www.viceregency.com/Abbrev.htm
    abbrev["eng"] = {
        "1": ("Gen", "Genesis"),
        "2": ("Exod", "Exodus"),
        "3": ("Lev", "Leviticus"),
        "4": ("Num", "Numbers"),
        "5": ("Deut", "Deuteronomy"),
        "6": ("Josh", "Joshua"),
        "7": ("Judg", "Judges"),
        "8": ("Ruth", "Ruth"),
        "9": ("1Sam", "1 Samuel"),
        "10": ("2Sam", "2 Samuel"),
        "11": ("1Kgs", "1 Kings"),
        "12": ("2Kgs", "2 Kings"),
        "13": ("1Chr", "1 Chronicles"),
        "14": ("2Chr", "2 Chronicles"),
        "15": ("Ezra", "Ezra"),
        "16": ("Neh", "Nehemiah"),
        "17": ("Esth", "Esther"),
        "18": ("Job", "Job"),
        "19": ("Ps", "Psalms"),
        "20": ("Prov", "Proverbs"),
        "21": ("Eccl", "Ecclesiastes"),
        "22": ("Song", "Song of Songs"),
        "23": ("Isa", "Isaiah"),
        "24": ("Jer", "Jeremiah"),
        "25": ("Lam", "Lamentations"),
        "26": ("Ezek", "Ezekiel"),
        "27": ("Dan", "Daniel"),
        "28": ("Hos", "Hosea"),
        "29": ("Joel", "Joel"),
        "30": ("Amos", "Amos"),
        "31": ("Obad", "Obadiah"),
        "32": ("Jonah", "Jonah"),
        "33": ("Mic", "Micah"),
        "34": ("Nah", "Nahum"),
        "35": ("Hab", "Habakkuk"),
        "36": ("Zeph", "Zephaniah"),
        "37": ("Hag", "Haggai"),
        "38": ("Zech", "Zechariah"),
        "39": ("Mal", "Malachi"),
        "40": ("Matt", "Matthew"),
        "41": ("Mark", "Mark"),
        "42": ("Luke", "Luke"),
        "43": ("John", "John"),
        "44": ("Acts", "Acts"),
        "45": ("Rom", "Romans"),
        "46": ("1Cor", "1 Corinthians"),
        "47": ("2Cor", "2 Corinthians"),
        "48": ("Gal", "Galatians"),
        "49": ("Eph", "Ephesians"),
        "50": ("Phil", "Philippians"),
        "51": ("Col", "Colossians"),
        "52": ("1Thess", "1 Thessalonians"),
        "53": ("2Thess", "2 Thessalonians"),
        "54": ("1Tim", "1 Timothy"),
        "55": ("2Tim", "2 Timothy"),
        "56": ("Titus", "Titus"),
        "57": ("Phlm", "Philemon"),
        "58": ("Heb", "Hebrews"),
        "59": ("Jas", "James"),
        "60": ("1Pet", "1 Peter"),
        "61": ("2Pet", "2 Peter"),
        "62": ("1John", "1 John"),
        "63": ("2John", "2 John"),
        "64": ("3John", "3 John"),
        "65": ("Jude", "Jude"),
        "66": ("Rev", "Revelation"),
        "67": ("", ""),
        "68": ("", ""),
        "69": ("", ""),
        "70": ("Bar", "Baruch"),
        "71": ("AddDan", "Additions to Daniel"),
        "72": ("PrAzar", "Prayer of Azariah"),
        "73": ("Bel", "Bel and the Dragon"),
        "74": ("", ""),
        "75": ("Sus", "Susanna"),
        "76": ("1Esd", "1 Esdras"),
        "77": ("2Esd", "2 Esdras"),
        "78": ("AddEsth", "Additions to Esther"),
        "79": ("EpJer", "Epistle of Jeremiah"),
        "80": ("Jdt", "Judith"),
        "81": ("1Macc", "1 Maccabees"),
        "82": ("2Macc", "2 Maccabees"),
        "83": ("3Macc", "3 Maccabees"),
        "84": ("4Macc", "4 Maccabees"),
        "85": ("PrMan", "Prayer of Manasseh"),
        "86": ("Ps151", "Psalm 151"),
        "87": ("Sir", "Sirach"),
        "88": ("Tob", "Tobit"),
        "89": ("Wis", "Wisdom of Solomon"),
        "90": ("PssSol", "Psalms of Solomon"),
        "91": ("Odes", "Odes"),
        "92": ("EpLao", "Epistle to Laodiceans"),
        "93": ("1Enoch", "1 Enoch"),
        "94": ("2Enoch", "2 Enoch"),
        "95": ("3Enoch", "3 Enoch"),
        "96": ("", ""),
        "97": ("2Bar", "2 Baruch"),
        "98": ("3Bar", "3 Baruch"),
        "99": ("4Bar", "4 Baruch"),
        "100": ("", ""),
        "101": ("LAE", "Life of Adam and Eve"),
        "102": ("2LAE", "2 Life of Adam and Eve"),
        "103": ("", ""),
        "104": ("", ""),
        "105": ("Herm", "Shepherd of Hermas"),
        "106": ("2Herm", "2 Shepherd of Hermas"),
        "107": ("3Herm", "3 Shepherd of Hermas"),
        "108": ("", ""),
        "109": ("", ""),
        "111": ("", ""),
        "112": ("Jasher", "Jasher"),
        "113": ("Jub", "Jubilees"),
        "114": ("", ""),
        "115": ("", ""),
        "116": ("Mart. Ascen. Isa.", "Martyrdom and Ascension of Isaiah"),
        "117": ("A. Peter", "Apocalypse of Peter"),
        "118": ("A. Sedrach", "Apocalypse of Sedrach"),
        "119": ("", ""),
        "120": ("T. Asher", "The Testament of Asher"),
        "121": ("T. Benjamin", "The Testament of Benjamin"),
        "122": ("T. Dan", "The Testament of Dan"),
        "123": ("T. Gad", "The Testament of Gad"),
        "124": ("T. Issachar", "The Testament of Issachar"),
        "125": ("T. Joseph", "The Testament of Joseph"),
        "126": ("T. Judah", "The Testament of Judah"),
        "127": ("T. Levi", "The Testament of Levi"),
        "128": ("T. Naphtali", "The Testament of Naphtali"),
        "129": ("T. Reuben", "The Testament of Reuben"),
        "130": ("T. Simeon", "The Testament of Simeon"),
        "131": ("T. Zebulun", "The Testament of Zebulun"),
        "132": ("T. Solomon", "Testament of Solomon"),
    }

    # mapping bible book abbreviation / bible book name to book number
    name2number = {
        "Ge.": "1",
        "Gen.": "1",
        "GEN.": "1",
        "Genesis": "1",
        "Gn.": "1",
        "Ex.": "2",
        "Exo.": "2",
        "EXO.": "2",
        "Exod.": "2",
        "Exodus": "2",
        "Le.": "3",
        "Lev.": "3",
        "LEV.": "3",
        "Leviticus": "3",
        "Lv.": "3",
        "Nb.": "4",
        "Nm.": "4",
        "Nu.": "4",
        "Num.": "4",
        "NUM.": "4",
        "Numbers": "4",
        "De.": "5",
        "Deu.": "5",
        "DEU.": "5",
        "Deut.": "5",
        "Deuteronomy": "5",
        "Dt.": "5",
        "Jos.": "6",
        "JOS.": "6",
        "Josh.": "6",
        "JoshA.": "6",
        "Joshua": "6",
        "Jsa.": "6",
        "JSA.": "6",
        "Jsh.": "6",
        "Jdb.": "7",
        "JDB.": "7",
        "Jdg.": "7",
        "JDG.": "7",
        "Jdgs.": "7",
        "Jg.": "7",
        "Judg.": "7",
        "JudgB.": "7",
        "Judges": "7",
        "Rth.": "8",
        "Ru.": "8",
        "Rut.": "8",
        "RUT.": "8",
        "Ruth": "8",
        "1 S.": "9",
        "1 Sa.": "9",
        "1 Sam.": "9",
        "1 Samuel": "9",
        "1 Sm.": "9",
        "1S.": "9",
        "1Sa.": "9",
        "1SA.": "9",
        "1Sam.": "9",
        "1st Sam.": "9",
        "1st Samuel": "9",
        "First Sam.": "9",
        "First Samuel": "9",
        "I Sa.": "9",
        "I Sam.": "9",
        "2 S.": "10",
        "2 Sa.": "10",
        "2 Sam.": "10",
        "2 Samuel": "10",
        "2 Sm.": "10",
        "2nd Sam.": "10",
        "2nd Samuel": "10",
        "2S.": "10",
        "2Sa.": "10",
        "2SA.": "10",
        "2Sam.": "10",
        "II Sa.": "10",
        "II Sam.": "10",
        "Second Sam.": "10",
        "Second Samuel": "10",
        "1 Kgs.": "11",
        "1 Ki.": "11",
        "1 Kings": "11",
        "1K.": "11",
        "1Kg.": "11",
        "1Kgs.": "11",
        "1Ki.": "11",
        "1KI.": "11",
        "1Kin.": "11",
        "1st Kgs.": "11",
        "1st Kings": "11",
        "First Kgs.": "11",
        "First Kings": "11",
        "I Kgs.": "11",
        "I Ki.": "11",
        "2 Kgs.": "12",
        "2 Ki.": "12",
        "2 Kings": "12",
        "2K.": "12",
        "2Kg.": "12",
        "2Kgs.": "12",
        "2Ki.": "12",
        "2KI.": "12",
        "2Kin.": "12",
        "2nd Kgs.": "12",
        "2nd Kings": "12",
        "II Kgs.": "12",
        "II Ki.": "12",
        "Second Kgs.": "12",
        "Second Kings": "12",
        "1 Ch.": "13",
        "1 Chr.": "13",
        "1 Chron.": "13",
        "1 Chronicles": "13",
        "1Ch.": "13",
        "1CH.": "13",
        "1Chr.": "13",
        "1Chron.": "13",
        "1st Chron.": "13",
        "1st Chronicles": "13",
        "First Chron.": "13",
        "First Chronicles": "13",
        "I Ch.": "13",
        "I Chr.": "13",
        "I Chron.": "13",
        "2 Ch.": "14",
        "2 Chr.": "14",
        "2 Chron.": "14",
        "2 Chronicles": "14",
        "2Ch.": "14",
        "2CH.": "14",
        "2Chr.": "14",
        "2Chron.": "14",
        "2nd Chron.": "14",
        "2nd Chronicles": "14",
        "II Ch.": "14",
        "II Chr.": "14",
        "II Chron.": "14",
        "Second Chron.": "14",
        "Second Chronicles": "14",
        "Ez.": "15",
        "Ezr.": "15",
        "EZR.": "15",
        "Ezra": "15",
        "Ne.": "16",
        "Neh.": "16",
        "NEH.": "16",
        "Nehemiah": "16",
        "Es.": "17",
        "Est.": "17",
        "EST.": "17",
        "Esth.": "17",
        "Esther": "17",
        "Jb.": "18",
        "Job": "18",
        "JOB": "18",
        "Ps.": "19",
        "Psa.": "19",
        "PSA.": "19",
        "Psalm": "19",
        "Psalms": "19",
        "Pslm.": "19",
        "Psm.": "19",
        "Pr.": "20",
        "Pro.": "20",
        "PRO.": "20",
        "Prov.": "20",
        "Proverbs": "20",
        "Prv.": "20",
        "Ec.": "21",
        "Ecc.": "21",
        "ECC.": "21",
        "Eccl.": "21",
        "Eccle.": "21",
        "Eccles.": "21",
        "Ecclesiastes": "21",
        "Qoh.": "21",
        "Cant.": "22",
        "Canticle of Canticles": "22",
        "Canticles": "22",
        "Sg.": "22",
        "Sng.": "22",
        "SNG.": "22",
        "So.": "22",
        "Son.": "22",
        "Song": "22",
        "Song of Solomon": "22",
        "Song of Songs": "22",
        "SOS.": "22",
        "Is.": "23",
        "Isa.": "23",
        "ISA.": "23",
        "Isaiah": "23",
        "Je.": "24",
        "Jer.": "24",
        "JER.": "24",
        "Jeremiah": "24",
        "Jr.": "24",
        "La.": "25",
        "Lam.": "25",
        "LAM.": "25",
        "Lamentations": "25",
        "Lm.": "25",
        "Eze.": "26",
        "Ezek.": "26",
        "Ezekiel": "26",
        "Ezk.": "26",
        "EZK.": "26",
        "Da.": "27",
        "Dan.": "27",
        "DAN.": "27",
        "Daniel": "27",
        "Dn.": "27",
        "Ho.": "28",
        "Hos.": "28",
        "HOS.": "28",
        "Hosea": "28",
        "Hs.": "28",
        "Jl.": "29",
        "Joe.": "29",
        "Joel": "29",
        "Jol.": "29",
        "JOL.": "29",
        "Am.": "30",
        "Amo.": "30",
        "AMO.": "30",
        "Amos": "30",
        "Ob.": "31",
        "Oba.": "31",
        "OBA.": "31",
        "Obad.": "31",
        "Obadiah": "31",
        "Jnh.": "32",
        "Jon.": "32",
        "JON.": "32",
        "Jonah": "32",
        "Mc.": "33",
        "Mic.": "33",
        "MIC.": "33",
        "Micah": "33",
        "Na.": "34",
        "Nah.": "34",
        "Nahum": "34",
        "Nam.": "34",
        "NAM.": "34",
        "Hab.": "35",
        "HAB.": "35",
        "Habakkuk": "35",
        "Hb.": "35",
        "Zep.": "36",
        "ZEP.": "36",
        "Zeph.": "36",
        "Zephaniah": "36",
        "Zp.": "36",
        "Zph.": "36",
        "Hag.": "37",
        "HAG.": "37",
        "Haggai": "37",
        "Hg.": "37",
        "Zc.": "38",
        "Zch.": "38",
        "Zec.": "38",
        "ZEC.": "38",
        "Zech.": "38",
        "Zechariah": "38",
        "Mal.": "39",
        "MAL.": "39",
        "Malachi": "39",
        "Ml.": "39",
        "Mat.": "40",
        "MAT.": "40",
        "Matt.": "40",
        "Matthew": "40",
        "Mt.": "40",
        "Mar.": "41",
        "Mark": "41",
        "Mk.": "41",
        "Mr.": "41",
        "Mrk.": "41",
        "MRK.": "41",
        "Lk.": "42",
        "Luk.": "42",
        "LUK.": "42",
        "Luke": "42",
        "Jhn.": "43",
        "JHN.": "43",
        "Jn.": "43",
        "Joh.": "43",
        "John": "43",
        "Ac.": "44",
        "Act.": "44",
        "ACT.": "44",
        "Acts": "44",
        "Rm.": "45",
        "Ro.": "45",
        "Rom.": "45",
        "ROM.": "45",
        "Romans": "45",
        "1 Co.": "46",
        "1 Cor.": "46",
        "1 Corinthians": "46",
        "1Co.": "46",
        "1CO.": "46",
        "1Cor.": "46",
        "1Corinthians": "46",
        "1st Corinthians": "46",
        "First Corinthians": "46",
        "I Co.": "46",
        "I Cor.": "46",
        "I Corinthians": "46",
        "2 Co.": "47",
        "2 Cor.": "47",
        "2 Corinthians": "47",
        "2Co.": "47",
        "2CO.": "47",
        "2Cor.": "47",
        "2Corinthians": "47",
        "2nd Corinthians": "47",
        "II Co.": "47",
        "II Cor.": "47",
        "II Corinthians": "47",
        "Second Corinthians": "47",
        "Ga.": "48",
        "Gal.": "48",
        "GAL.": "48",
        "Galatians": "48",
        "Gl.": "48",
        "Eph.": "49",
        "EPH.": "49",
        "Ephes.": "49",
        "Ephesians": "49",
        "Phi.": "50",
        "Phil.": "50",
        "Philip.": "50",
        "Philippians": "50",
        "Php.": "50",
        "PHP.": "50",
        "Pp.": "50",
        "Co.": "51",
        "Col.": "51",
        "COL.": "51",
        "Colossians": "51",
        "1 Th.": "52",
        "1 Thes.": "52",
        "1 Thess.": "52",
        "1 Thessalonians": "52",
        "1st Thess.": "52",
        "1st Thessalonians": "52",
        "1Th.": "52",
        "1TH.": "52",
        "1Thes.": "52",
        "1Thess.": "52",
        "1Thessalonians": "52",
        "First Thess.": "52",
        "First Thessalonians": "52",
        "I Th.": "52",
        "I Thes.": "52",
        "I Thess.": "52",
        "I Thessalonians": "52",
        "2 Th.": "53",
        "2 Thes.": "53",
        "2 Thess.": "53",
        "2 Thessalonians": "53",
        "2nd Thess.": "53",
        "2nd Thessalonians": "53",
        "2Th.": "53",
        "2TH.": "53",
        "2Thes.": "53",
        "2Thess.": "53",
        "2Thessalonians": "53",
        "II Th.": "53",
        "II Thes.": "53",
        "II Thess.": "53",
        "II Thessalonians": "53",
        "Second Thess.": "53",
        "Second Thessalonians": "53",
        "1 Ti.": "54",
        "1 Tim.": "54",
        "1 Timothy": "54",
        "1st Tim.": "54",
        "1st Timothy": "54",
        "1Ti.": "54",
        "1TI.": "54",
        "1Tim.": "54",
        "1Timothy": "54",
        "1Tm.": "54",
        "First Tim.": "54",
        "First Timothy": "54",
        "I Ti.": "54",
        "I Tim.": "54",
        "I Timothy": "54",
        "2 Ti.": "55",
        "2 Tim.": "55",
        "2 Timothy": "55",
        "2nd Tim.": "55",
        "2nd Timothy": "55",
        "2Ti.": "55",
        "2TI.": "55",
        "2Tim.": "55",
        "2Timothy": "55",
        "2Tm.": "55",
        "II Ti.": "55",
        "II Tim.": "55",
        "II Timothy": "55",
        "Second Tim.": "55",
        "Second Timothy": "55",
        "Tit.": "56",
        "TIT.": "56",
        "Titus": "56",
        "Philem.": "57",
        "Philemon": "57",
        "Phlm.": "57",
        "Phm.": "57",
        "PHM.": "57",
        "Pm.": "57",
        "Heb.": "58",
        "HEB.": "58",
        "Hebrews": "58",
        "Jam.": "59",
        "James": "59",
        "Jas.": "59",
        "JAS.": "59",
        "Jms.": "59",
        "Jm.": "59",
        "Js.": "59",
        "1 P.": "60",
        "1 Pe.": "60",
        "1 Pet.": "60",
        "1 Peter": "60",
        "1 Pt.": "60",
        "1P.": "60",
        "1Pe.": "60",
        "1PE.": "60",
        "1Pet.": "60",
        "1Peter": "60",
        "1Pt.": "60",
        "1st Peter": "60",
        "First Peter": "60",
        "I Pe.": "60",
        "I Pet.": "60",
        "I Peter": "60",
        "I Pt.": "60",
        "2 P.": "61",
        "2 Pe.": "61",
        "2 Pet.": "61",
        "2 Peter": "61",
        "2 Pt.": "61",
        "2nd Peter": "61",
        "2P.": "61",
        "2Pe.": "61",
        "2PE.": "61",
        "2Pet.": "61",
        "2Peter": "61",
        "2Pt.": "61",
        "II Pe.": "61",
        "II Pet.": "61",
        "II Peter": "61",
        "II Pt.": "61",
        "Second Peter": "61",
        "1 J.": "62",
        "1 Jhn.": "62",
        "1 Jn.": "62",
        "1 John": "62",
        "1J.": "62",
        "1Jhn.": "62",
        "1Jn.": "62",
        "1JN.": "62",
        "1Jo.": "62",
        "1Joh.": "62",
        "1John": "62",
        "1st John": "62",
        "First John": "62",
        "I Jhn.": "62",
        "I Jn.": "62",
        "I Jo.": "62",
        "I Joh.": "62",
        "I John": "62",
        "2 J.": "63",
        "2 Jhn.": "63",
        "2 Jn.": "63",
        "2 John": "63",
        "2J.": "63",
        "2Jhn.": "63",
        "2Jn.": "63",
        "2JN.": "63",
        "2Jo.": "63",
        "2Joh.": "63",
        "2John": "63",
        "2nd John": "63",
        "II Jhn.": "63",
        "II Jn.": "63",
        "II Jo.": "63",
        "II Joh.": "63",
        "II John": "63",
        "Second John": "63",
        "3 J.": "64",
        "3 Jhn.": "64",
        "3 Jn.": "64",
        "3 John": "64",
        "3J.": "64",
        "3Jhn.": "64",
        "3Jn.": "64",
        "3JN.": "64",
        "3Jo.": "64",
        "3Joh.": "64",
        "3John": "64",
        "3rd John": "64",
        "III Jhn.": "64",
        "III Jn.": "64",
        "III Jo.": "64",
        "III Joh.": "64",
        "III John": "64",
        "Third John": "64",
        "Jd.": "65",
        "Jud.": "65",
        "JUD.": "65",
        "Jude": "65",
        "Apocalypse of John": "66",
        "Re.": "66",
        "Rev.": "66",
        "REV.": "66",
        "Revelation": "66",
        "Revelation to John": "66",
        "Rv.": "66",
        "The Revelation": "66",
        "Bar": "70",
        "Bar.": "70",
        "BAR.": "70",
        "Baruch": "70",
        "1 Baruch": "70",
        "Add. Dan.": "71",
        "Adddan.": "71",
        "AddDan.": "71",
        "Additions to Daniel": "71",
        "Dag.": "71",
        "DAG.": "71",
        "DanGr.": "71",
        "DanTh.": "71",
        "Dnt.": "71",
        "DNT.": "71",
        "Azariah": "72",
        "Pr. Az.": "72",
        "Pr. Azar.": "72",
        "Prayer of Azariah": "72",
        "PrAzar.": "72",
        "S3Y.": "72",
        "Sg. of 3 Childr.": "72",
        "Sg. Three": "72",
        "Song of the Three Holy Children": "72",
        "Song of Thr.": "72",
        "Song of Three": "72",
        "Song of Three Children": "72",
        "Song of Three Jews": "72",
        "Song of Three Youths": "72",
        "Song Thr.": "72",
        "The Song of the Three Holy Children": "72",
        "The Song of Three Jews": "72",
        "The Song of Three Youths": "72",
        "Bel": "73",
        "BEL": "73",
        "Bel and Dr.": "73",
        "Bel and the Dragon": "73",
        "Bel.": "73",
        "BelTh.": "73",
        "Blt.": "73",
        "BLT.": "73",
        "Sst.": "75",
        "SST.": "75",
        "Sus.": "75",
        "SUS.": "75",
        "Susanna": "75",
        "SusTh.": "75",
        "1 Esd.": "76",
        "1 Esdr.": "76",
        "1 Esdras": "76",
        "1Es.": "76",
        "1ES.": "76",
        "1Esd.": "76",
        "1Esdr.": "76",
        "1Esdras.": "76",
        "1st Esdras": "76",
        "First Esdras": "76",
        "I Es.": "76",
        "I Esd.": "76",
        "I Esdr.": "76",
        "I Esdras": "76",
        "2 Esd.": "77",
        "2 Esdr.": "77",
        "2 Esdras": "77",
        "2Es.": "77",
        "2ES.": "77",
        "2Esd.": "77",
        "2Esdr.": "77",
        "2Esdras": "77",
        "2nd Esdras": "77",
        "II Es.": "77",
        "II Esd.": "77",
        "II Esdr.": "77",
        "II Esdras": "77",
        "Second Esdras": "77",
        "Add. Es.": "78",
        "Add. Esth.": "78",
        "AddEsth.": "78",
        "Additions to Esther": "78",
        "Ade.": "78",
        "ADE.": "78",
        "AEs.": "78",
        "Esg.": "78",
        "ESG.": "78",
        "EsthGr.": "78",
        "Rest of Esther": "78",
        "The Rest of Esther": "78",
        "Ep. Jer.": "79",
        "EpJer.": "79",
        "Let. Jer.": "79",
        "Letter of Jeremiah": "79",
        "Lje.": "79",
        "LJe.": "79",
        "LJE.": "79",
        "Ltr. Jer.": "79",
        "Jdt.": "80",
        "JDT.": "80",
        "Jdth.": "80",
        "Jth.": "80",
        "Judith": "80",
        "1 Mac.": "81",
        "1 Macc.": "81",
        "1 Maccabees": "81",
        "1M.": "81",
        "1Ma.": "81",
        "1MA.": "81",
        "1Mac.": "81",
        "1Macc.": "81",
        "1Maccabees": "81",
        "1st Maccabees": "81",
        "First Maccabees": "81",
        "I Ma.": "81",
        "I Mac.": "81",
        "I Macc.": "81",
        "I Maccabees": "81",
        "2 Mac.": "82",
        "2 Macc.": "82",
        "2 Maccabees": "82",
        "2M.": "82",
        "2Ma.": "82",
        "2MA.": "82",
        "2Mac.": "82",
        "2Macc.": "82",
        "2Maccabees": "82",
        "2nd Maccabees": "82",
        "II Ma.": "82",
        "II Mac.": "82",
        "II Macc.": "82",
        "II Maccabees": "82",
        "Second Maccabees": "82",
        "3 Mac.": "83",
        "3 Macc.": "83",
        "3 Maccabees": "83",
        "3M.": "83",
        "3Ma.": "83",
        "3MA.": "83",
        "3Mac.": "83",
        "3Macc.": "83",
        "3Maccabees": "83",
        "3rd Maccabees": "83",
        "III Ma.": "83",
        "III Mac.": "83",
        "III Macc.": "83",
        "III Maccabees": "83",
        "Third Maccabees": "83",
        "4 Mac.": "84",
        "4 Macc.": "84",
        "4 Maccabees": "84",
        "4M.": "84",
        "4Ma.": "84",
        "4MA.": "84",
        "4Mac.": "84",
        "4Macc.": "84",
        "4Maccabees": "84",
        "4th Maccabees": "84",
        "Fourth Maccabees": "84",
        "IV Ma.": "84",
        "IV Mac.": "84",
        "IV Macc.": "84",
        "IV Maccabees": "84",
        "Man.": "85",
        "MAN.": "85",
        "PMa.": "85",
        "Pr. Man": "85",
        "Pr. of Man.": "85",
        "Prayer of Manasseh": "85",
        "Prayer of Manasses": "85",
        "PrMan.": "85",
        "Add. Ps.": "86",
        "Add. Psalm": "86",
        "Additional Psalm": "86",
        "AddPs.": "86",
        "Ps. 151": "86",
        "Ps2.": "86",
        "PS2.": "86",
        "Ps151": "86",
        "Psalm 151": "86",
        "Ecclesiasticus": "87",
        "Ecclus.": "87",
        "Sir.": "87",
        "SIR.": "87",
        "Sirach": "87",
        "Sirp.": "87",
        "SirP.": "87",
        "Tb.": "88",
        "Tbs.": "88",
        "TBS.": "88",
        "TOB": "88",
        "Tob.": "88",
        "Tobit": "88",
        "TobS.": "88",
        "Wis.": "89",
        "WIS.": "89",
        "Wisd. of Sol.": "89",
        "Wisdom": "89",
        "Wisdom of Solomon": "89",
        "Ws.": "89",
        "Ps. Sol.": "90",
        "Ps. Solomon": "90",
        "Psalms of Solomon": "90",
        "Psalms Solomon": "90",
        "Pss.": "90",
        "PSS.": "90",
        "PsSol.": "90",
        "PssSol.": "90",
        "Oda.": "91",
        "ODA.": "91",
        "Ode.": "91",
        "Odes": "91",
        "Ep. Lao.": "92",
        "Ep. Laod.": "92",
        "Epist. Laodiceans": "92",
        "Epistle Laodiceans": "92",
        "Epistle to Laodiceans": "92",
        "Epistle to the Laodiceans": "92",
        "EpLao.": "92",
        "Lao.": "92",
        "Laod.": "92",
        "Laodiceans": "92",
        "1En": "93",
        "1Enoch": "93",
        "1 Enoch": "93",
        "2En": "94",
        "2Enoch": "94",
        "2 Enoch": "94",
        "3Enoch": "95",
        "3 Enoch": "95",
        "3En": "95",
        "2Bar": "97",
        "2 Baruch": "97",
        "3Bar": "98",
        "3 Baruch": "98",
        "4Bar": "99",
        "4 Baruch": "99",
        "LAE": "101",
        "L.A.E.": "101",
        "Adam": "101",
        "Eve": "101",
        "AdamEve": "101",
        "Adam and Eve": "101",
        "Life of Adam and Eve": "101",
        "2LAE": "102",
        "2L.A.E.": "102",
        "2AdamEve": "102",
        "2 Adam and Eve": "102",
        "2 Life of Adam and Eve": "102",
        "Herm": "105",
        "Herm.": "105",
        "Hermas": "105",
        "Shepherd of Hermas": "105",
        "2Herm": "106",
        "2Herm.": "106",
        "2 Hermas": "106",
        "2 Shepherd of Hermas": "106",
        "3Herm": "107",
        "3Herm.": "107",
        "3 Hermas": "107",
        "3 Shepherd of Hermas": "107",
        "Jasher": "112",
        "Jub": "113",
        "Jubilee": "113",
        "Jubilees": "113",
        "Mart. Ascen. Isa.": "116",
        "Martyrdom and Ascension of Isaiah": "116",
        "Ascension of Isaiah": "116",
        "The Ascension of Isaiah": "116",
        "A. Peter": "117",
        "Apoc Pet.": "117",
        "Apocalypse of Peter": "117",
        "The Apocalypse of Peter": "117",
        "A. Sedrach": "118",
        "Apoc Sedrach": "118",
        "Apocalypse of Sedrach": "118",
        "The Apocalypse of Sedrach": "118",
        "T. Asher": "120",
        "The Testament of Asher": "120",
        "T. Benjamin": "121",
        "The Testament of Benjamin": "121",
        "T. Dan": "122",
        "The Testament of Dan": "122",
        "T. Gad": "123",
        "The Testament of Gad": "123",
        "T. Issachar": "124",
        "The Testament of Issachar": "124",
        "T. Joseph": "125",
        "The Testament of Joseph": "125",
        "T. Judah": "126",
        "The Testament of Judah": "126",
        "T. Levi": "127",
        "The Testament of Levi": "127",
        "T. Naphtali": "128",
        "The Testament of Naphtali": "128",
        "T. Reuben": "129",
        "The Testament of Reuben": "129",
        "T. Simeon": "130",
        "The Testament of Simeon": "130",
        "T. Zebulun": "131",
        "The Testament of Zebulun": "131",
        "T. Sol.": "132",
        "T. Solomon": "132",
        "The Testament of Solomon": "132",
    }

    chapters = {
        1:50,
        2:40,
        3:27,
        4:36,
        5:34,
        6:24,
        7:21,
        8:4,
        9:31,
        10:24,
        11:22,
        12:25,
        13:29,
        14:36,
        15:10,
        16:13,
        17:10,
        18:42,
        19:150,
        20:31,
        21:12,
        22:8,
        23:66,
        24:52,
        25:5,
        26:48,
        27:12,
        28:14,
        29:3,
        30:9,
        31:1,
        32:4,
        33:7,
        34:3,
        35:3,
        36:3,
        37:2,
        38:14,
        39:4,
        40:28,
        41:16,
        42:24,
        43:21,
        44:28,
        45:16,
        46:16,
        47:13,
        48:6,
        49:6,
        50:4,
        51:4,
        52:5,
        53:3,
        54:6,
        55:4,
        56:3,
        57:1,
        58:13,
        59:5,
        60:5,
        61:3,
        62:5,
        63:1,
        64:1,
        65:1,
        66:22,
        70:5,
        72:1,
        73:1,
        75:1,
        76:9,
        77:16,
        78:7,
        80:16,
        81:16,
        82:15,
        85:1,
        87:51,
        88:14,
        89:19,
        93:108,
        94:68,
        95:48,
        97:87,
        98:17,
        99:9,
        101:79,
        102:22,
        105:4,
        106:12,
        107:9,
        112:91,
        113:50,
        116:11,
        117:17,
        118:1,
        120:1,
        121:2,
        122:2,
        123:2,
        124:2,
        125:2,
        126:4,
        127:5,
        128:2,
        129:2,
        130:3,
        131:2,
        132:1
    }

    verses = {
        1: {
            1: 31,
            2: 25,
            3: 24,
            4: 26,
            5: 32,
            6: 22,
            7: 24,
            8: 22,
            9: 29,
            10: 32,
            11: 32,
            12: 20,
            13: 18,
            14: 24,
            15: 21,
            16: 16,
            17: 27,
            18: 33,
            19: 38,
            20: 18,
            21: 34,
            22: 24,
            23: 20,
            24: 67,
            25: 34,
            26: 35,
            27: 46,
            28: 22,
            29: 35,
            30: 43,
            31: 55,
            32: 32,
            33: 20,
            34: 31,
            35: 29,
            36: 43,
            37: 36,
            38: 30,
            39: 23,
            40: 23,
            41: 57,
            42: 38,
            43: 34,
            44: 34,
            45: 28,
            46: 34,
            47: 31,
            48: 22,
            49: 33,
            50: 26,
        },
        2: {
            1: 22,
            2: 25,
            3: 22,
            4: 31,
            5: 23,
            6: 30,
            7: 25,
            8: 32,
            9: 35,
            10: 29,
            11: 10,
            12: 51,
            13: 22,
            14: 31,
            15: 27,
            16: 36,
            17: 16,
            18: 27,
            19: 25,
            20: 26,
            21: 36,
            22: 31,
            23: 33,
            24: 18,
            25: 40,
            26: 37,
            27: 21,
            28: 43,
            29: 46,
            30: 38,
            31: 18,
            32: 35,
            33: 23,
            34: 35,
            35: 35,
            36: 38,
            37: 29,
            38: 31,
            39: 43,
            40: 38,
        },
        3: {
            1: 17,
            2: 16,
            3: 17,
            4: 35,
            5: 19,
            6: 30,
            7: 38,
            8: 36,
            9: 24,
            10: 20,
            11: 47,
            12: 8,
            13: 59,
            14: 57,
            15: 33,
            16: 34,
            17: 16,
            18: 30,
            19: 37,
            20: 27,
            21: 24,
            22: 33,
            23: 44,
            24: 23,
            25: 55,
            26: 46,
            27: 34,
        },
        4: {
            1: 54,
            2: 34,
            3: 51,
            4: 49,
            5: 31,
            6: 27,
            7: 89,
            8: 26,
            9: 23,
            10: 36,
            11: 35,
            12: 16,
            13: 33,
            14: 45,
            15: 41,
            16: 50,
            17: 13,
            18: 32,
            19: 22,
            20: 29,
            21: 35,
            22: 41,
            23: 30,
            24: 25,
            25: 18,
            26: 65,
            27: 23,
            28: 31,
            29: 40,
            30: 16,
            31: 54,
            32: 42,
            33: 56,
            34: 29,
            35: 34,
            36: 13,
        },
        5: {
            1: 46,
            2: 37,
            3: 29,
            4: 49,
            5: 33,
            6: 25,
            7: 26,
            8: 20,
            9: 29,
            10: 22,
            11: 32,
            12: 32,
            13: 18,
            14: 29,
            15: 23,
            16: 22,
            17: 20,
            18: 22,
            19: 21,
            20: 20,
            21: 23,
            22: 30,
            23: 25,
            24: 22,
            25: 19,
            26: 19,
            27: 26,
            28: 68,
            29: 29,
            30: 20,
            31: 30,
            32: 52,
            33: 29,
            34: 12,
        },
        6: {
            1: 18,
            2: 24,
            3: 17,
            4: 24,
            5: 15,
            6: 27,
            7: 26,
            8: 35,
            9: 27,
            10: 43,
            11: 23,
            12: 24,
            13: 33,
            14: 15,
            15: 63,
            16: 10,
            17: 18,
            18: 28,
            19: 51,
            20: 9,
            21: 45,
            22: 34,
            23: 16,
            24: 33,
        },
        7: {
            1: 36,
            2: 23,
            3: 31,
            4: 24,
            5: 31,
            6: 40,
            7: 25,
            8: 35,
            9: 57,
            10: 18,
            11: 40,
            12: 15,
            13: 25,
            14: 20,
            15: 20,
            16: 31,
            17: 13,
            18: 31,
            19: 30,
            20: 48,
            21: 25,
        },
        8: {
            1: 22,
            2: 23,
            3: 18,
            4: 22,
        },
        9: {
            1: 28,
            2: 36,
            3: 21,
            4: 22,
            5: 12,
            6: 21,
            7: 17,
            8: 22,
            9: 27,
            10: 27,
            11: 15,
            12: 25,
            13: 23,
            14: 52,
            15: 35,
            16: 23,
            17: 58,
            18: 30,
            19: 24,
            20: 42,
            21: 15,
            22: 23,
            23: 29,
            24: 22,
            25: 44,
            26: 25,
            27: 12,
            28: 25,
            29: 11,
            30: 31,
            31: 13,
        },
        10: {
            1: 27,
            2: 32,
            3: 39,
            4: 12,
            5: 25,
            6: 23,
            7: 29,
            8: 18,
            9: 13,
            10: 19,
            11: 27,
            12: 31,
            13: 39,
            14: 33,
            15: 37,
            16: 23,
            17: 29,
            18: 33,
            19: 43,
            20: 26,
            21: 22,
            22: 51,
            23: 39,
            24: 25,
        },
        11: {
            1: 53,
            2: 46,
            3: 28,
            4: 34,
            5: 18,
            6: 38,
            7: 51,
            8: 66,
            9: 28,
            10: 29,
            11: 43,
            12: 33,
            13: 34,
            14: 31,
            15: 34,
            16: 34,
            17: 24,
            18: 46,
            19: 21,
            20: 43,
            21: 29,
            22: 53,
        },
        12: {
            1: 18,
            2: 25,
            3: 27,
            4: 44,
            5: 27,
            6: 33,
            7: 20,
            8: 29,
            9: 37,
            10: 36,
            11: 21,
            12: 21,
            13: 25,
            14: 29,
            15: 38,
            16: 20,
            17: 41,
            18: 37,
            19: 37,
            20: 21,
            21: 26,
            22: 20,
            23: 37,
            24: 20,
            25: 30,
        },
        13: {
            1: 54,
            2: 55,
            3: 24,
            4: 43,
            5: 26,
            6: 81,
            7: 40,
            8: 40,
            9: 44,
            10: 14,
            11: 47,
            12: 40,
            13: 14,
            14: 17,
            15: 29,
            16: 43,
            17: 27,
            18: 17,
            19: 19,
            20: 8,
            21: 30,
            22: 19,
            23: 32,
            24: 31,
            25: 31,
            26: 32,
            27: 34,
            28: 21,
            29: 30,
        },
        14: {
            1: 17,
            2: 18,
            3: 17,
            4: 22,
            5: 14,
            6: 42,
            7: 22,
            8: 18,
            9: 31,
            10: 19,
            11: 23,
            12: 16,
            13: 22,
            14: 15,
            15: 19,
            16: 14,
            17: 19,
            18: 34,
            19: 11,
            20: 37,
            21: 20,
            22: 12,
            23: 21,
            24: 27,
            25: 28,
            26: 23,
            27: 9,
            28: 27,
            29: 36,
            30: 27,
            31: 21,
            32: 33,
            33: 25,
            34: 33,
            35: 27,
            36: 23,
        },
        15: {
            1: 11,
            2: 70,
            3: 13,
            4: 24,
            5: 17,
            6: 22,
            7: 28,
            8: 36,
            9: 15,
            10: 44,
        },
        16: {
            1: 11,
            2: 20,
            3: 32,
            4: 23,
            5: 19,
            6: 19,
            7: 73,
            8: 18,
            9: 38,
            10: 39,
            11: 36,
            12: 47,
            13: 31,
        },
        17: {
            1: 22,
            2: 23,
            3: 15,
            4: 17,
            5: 14,
            6: 14,
            7: 10,
            8: 17,
            9: 32,
            10: 3,
        },
        18: {
            1: 22,
            2: 13,
            3: 26,
            4: 21,
            5: 27,
            6: 30,
            7: 21,
            8: 22,
            9: 35,
            10: 22,
            11: 20,
            12: 25,
            13: 28,
            14: 22,
            15: 35,
            16: 22,
            17: 16,
            18: 21,
            19: 29,
            20: 29,
            21: 34,
            22: 30,
            23: 17,
            24: 25,
            25: 6,
            26: 14,
            27: 23,
            28: 28,
            29: 25,
            30: 31,
            31: 40,
            32: 22,
            33: 33,
            34: 37,
            35: 16,
            36: 33,
            37: 24,
            38: 41,
            39: 30,
            40: 24,
            41: 34,
            42: 17,
        },
        19: {
            1: 6,
            2: 12,
            3: 8,
            4: 8,
            5: 12,
            6: 10,
            7: 17,
            8: 9,
            9: 20,
            10: 18,
            11: 7,
            12: 8,
            13: 6,
            14: 7,
            15: 5,
            16: 11,
            17: 15,
            18: 50,
            19: 14,
            20: 9,
            21: 13,
            22: 31,
            23: 6,
            24: 10,
            25: 22,
            26: 12,
            27: 14,
            28: 9,
            29: 11,
            30: 12,
            31: 24,
            32: 11,
            33: 22,
            34: 22,
            35: 28,
            36: 12,
            37: 40,
            38: 22,
            39: 13,
            40: 17,
            41: 13,
            42: 11,
            43: 5,
            44: 26,
            45: 17,
            46: 11,
            47: 9,
            48: 14,
            49: 20,
            50: 23,
            51: 19,
            52: 9,
            53: 6,
            54: 7,
            55: 23,
            56: 13,
            57: 11,
            58: 11,
            59: 17,
            60: 12,
            61: 8,
            62: 12,
            63: 11,
            64: 10,
            65: 13,
            66: 20,
            67: 7,
            68: 35,
            69: 36,
            70: 5,
            71: 24,
            72: 20,
            73: 28,
            74: 23,
            75: 10,
            76: 12,
            77: 20,
            78: 72,
            79: 13,
            80: 19,
            81: 16,
            82: 8,
            83: 18,
            84: 12,
            85: 13,
            86: 17,
            87: 7,
            88: 18,
            89: 52,
            90: 17,
            91: 16,
            92: 15,
            93: 5,
            94: 23,
            95: 11,
            96: 13,
            97: 12,
            98: 9,
            99: 9,
            100: 5,
            101: 8,
            102: 28,
            103: 22,
            104: 35,
            105: 45,
            106: 48,
            107: 43,
            108: 13,
            109: 31,
            110: 7,
            111: 10,
            112: 10,
            113: 9,
            114: 8,
            115: 18,
            116: 19,
            117: 2,
            118: 29,
            119: 176,
            120: 7,
            121: 8,
            122: 9,
            123: 4,
            124: 8,
            125: 5,
            126: 6,
            127: 5,
            128: 6,
            129: 8,
            130: 8,
            131: 3,
            132: 18,
            133: 3,
            134: 3,
            135: 21,
            136: 26,
            137: 9,
            138: 8,
            139: 24,
            140: 13,
            141: 10,
            142: 7,
            143: 12,
            144: 15,
            145: 21,
            146: 10,
            147: 20,
            148: 14,
            149: 9,
            150: 6,
        },
        20: {
            1: 33,
            2: 22,
            3: 35,
            4: 27,
            5: 23,
            6: 35,
            7: 27,
            8: 36,
            9: 18,
            10: 32,
            11: 31,
            12: 28,
            13: 25,
            14: 35,
            15: 33,
            16: 33,
            17: 28,
            18: 24,
            19: 29,
            20: 30,
            21: 31,
            22: 29,
            23: 35,
            24: 34,
            25: 28,
            26: 28,
            27: 27,
            28: 28,
            29: 27,
            30: 33,
            31: 31,
        },
        21: {
            1: 18,
            2: 26,
            3: 22,
            4: 16,
            5: 20,
            6: 12,
            7: 29,
            8: 17,
            9: 18,
            10: 20,
            11: 10,
            12: 14,
        },
        22: {
            1: 17,
            2: 17,
            3: 11,
            4: 16,
            5: 16,
            6: 13,
            7: 13,
            8: 14,
        },
        23: {
            1: 31,
            2: 22,
            3: 26,
            4: 6,
            5: 30,
            6: 13,
            7: 25,
            8: 22,
            9: 21,
            10: 34,
            11: 16,
            12: 6,
            13: 22,
            14: 32,
            15: 9,
            16: 14,
            17: 14,
            18: 7,
            19: 25,
            20: 6,
            21: 17,
            22: 25,
            23: 18,
            24: 23,
            25: 12,
            26: 21,
            27: 13,
            28: 29,
            29: 24,
            30: 33,
            31: 9,
            32: 20,
            33: 24,
            34: 17,
            35: 10,
            36: 22,
            37: 38,
            38: 22,
            39: 8,
            40: 31,
            41: 29,
            42: 25,
            43: 28,
            44: 28,
            45: 25,
            46: 13,
            47: 15,
            48: 22,
            49: 26,
            50: 11,
            51: 23,
            52: 15,
            53: 12,
            54: 17,
            55: 13,
            56: 12,
            57: 21,
            58: 14,
            59: 21,
            60: 22,
            61: 11,
            62: 12,
            63: 19,
            64: 12,
            65: 25,
            66: 24,
        },
        24: {
            1: 19,
            2: 37,
            3: 25,
            4: 31,
            5: 31,
            6: 30,
            7: 34,
            8: 22,
            9: 26,
            10: 25,
            11: 23,
            12: 17,
            13: 27,
            14: 22,
            15: 21,
            16: 21,
            17: 27,
            18: 23,
            19: 15,
            20: 18,
            21: 14,
            22: 30,
            23: 40,
            24: 10,
            25: 38,
            26: 24,
            27: 22,
            28: 17,
            29: 32,
            30: 24,
            31: 40,
            32: 44,
            33: 26,
            34: 22,
            35: 19,
            36: 32,
            37: 21,
            38: 28,
            39: 18,
            40: 16,
            41: 18,
            42: 22,
            43: 13,
            44: 30,
            45: 5,
            46: 28,
            47: 7,
            48: 47,
            49: 39,
            50: 46,
            51: 64,
            52: 34,
        },
        25: {
            1: 22,
            2: 22,
            3: 66,
            4: 22,
            5: 22,
        },
        26: {
            1: 28,
            2: 10,
            3: 27,
            4: 17,
            5: 17,
            6: 14,
            7: 27,
            8: 18,
            9: 11,
            10: 22,
            11: 25,
            12: 28,
            13: 23,
            14: 23,
            15: 8,
            16: 63,
            17: 24,
            18: 32,
            19: 14,
            20: 49,
            21: 32,
            22: 31,
            23: 49,
            24: 27,
            25: 17,
            26: 21,
            27: 36,
            28: 26,
            29: 21,
            30: 26,
            31: 18,
            32: 32,
            33: 33,
            34: 31,
            35: 15,
            36: 38,
            37: 28,
            38: 23,
            39: 29,
            40: 49,
            41: 26,
            42: 20,
            43: 27,
            44: 31,
            45: 25,
            46: 24,
            47: 23,
            48: 35,
        },
        27: {
            1: 21,
            2: 49,
            3: 30,
            4: 37,
            5: 31,
            6: 28,
            7: 28,
            8: 27,
            9: 27,
            10: 21,
            11: 45,
            12: 13,
        },
        28: {
            1: 11,
            2: 23,
            3: 5,
            4: 19,
            5: 15,
            6: 11,
            7: 16,
            8: 14,
            9: 17,
            10: 15,
            11: 12,
            12: 14,
            13: 16,
            14: 9,
        },
        29: {
            1: 20,
            2: 32,
            3: 21,
        },
        30: {
            1: 15,
            2: 16,
            3: 15,
            4: 13,
            5: 27,
            6: 14,
            7: 17,
            8: 14,
            9: 15,
        },
        31: {
            1: 21,
        },
        32: {
            1: 17,
            2: 10,
            3: 10,
            4: 11,
        },
        33: {
            1: 16,
            2: 13,
            3: 12,
            4: 13,
            5: 15,
            6: 16,
            7: 20,
        },
        34: {
            1: 15,
            2: 13,
            3: 19,
        },
        35: {
            1: 17,
            2: 20,
            3: 19,
        },
        36: {
            1: 18,
            2: 15,
            3: 20,
        },
        37: {
            1: 15,
            2: 23,
        },
        38: {
            1: 21,
            2: 13,
            3: 10,
            4: 14,
            5: 11,
            6: 15,
            7: 14,
            8: 23,
            9: 17,
            10: 12,
            11: 17,
            12: 14,
            13: 9,
            14: 21,
        },
        39: {
            1: 14,
            2: 17,
            3: 18,
            4: 6,
        },
        40: {
            1: 25,
            2: 23,
            3: 17,
            4: 25,
            5: 48,
            6: 34,
            7: 29,
            8: 34,
            9: 38,
            10: 42,
            11: 30,
            12: 50,
            13: 58,
            14: 36,
            15: 39,
            16: 28,
            17: 27,
            18: 35,
            19: 30,
            20: 34,
            21: 46,
            22: 46,
            23: 39,
            24: 51,
            25: 46,
            26: 75,
            27: 66,
            28: 20,
        },
        41: {
            1: 45,
            2: 28,
            3: 35,
            4: 41,
            5: 43,
            6: 56,
            7: 37,
            8: 38,
            9: 50,
            10: 52,
            11: 33,
            12: 44,
            13: 37,
            14: 72,
            15: 47,
            16: 20,
        },
        42: {
            1: 80,
            2: 52,
            3: 38,
            4: 44,
            5: 39,
            6: 49,
            7: 50,
            8: 56,
            9: 62,
            10: 42,
            11: 54,
            12: 59,
            13: 35,
            14: 35,
            15: 32,
            16: 31,
            17: 37,
            18: 43,
            19: 48,
            20: 47,
            21: 38,
            22: 71,
            23: 56,
            24: 53,
        },
        43: {
            1: 51,
            2: 25,
            3: 36,
            4: 54,
            5: 47,
            6: 71,
            7: 53,
            8: 59,
            9: 41,
            10: 42,
            11: 57,
            12: 50,
            13: 38,
            14: 31,
            15: 27,
            16: 33,
            17: 26,
            18: 40,
            19: 42,
            20: 31,
            21: 25,
        },
        44: {
            1: 26,
            2: 47,
            3: 26,
            4: 37,
            5: 42,
            6: 15,
            7: 60,
            8: 40,
            9: 43,
            10: 48,
            11: 30,
            12: 25,
            13: 52,
            14: 28,
            15: 41,
            16: 40,
            17: 34,
            18: 28,
            19: 41,
            20: 38,
            21: 40,
            22: 30,
            23: 35,
            24: 27,
            25: 27,
            26: 32,
            27: 44,
            28: 31,
        },
        45: {
            1: 32,
            2: 29,
            3: 31,
            4: 25,
            5: 21,
            6: 23,
            7: 25,
            8: 39,
            9: 33,
            10: 21,
            11: 36,
            12: 21,
            13: 14,
            14: 23,
            15: 33,
            16: 27,
        },
        46: {
            1: 31,
            2: 16,
            3: 23,
            4: 21,
            5: 13,
            6: 20,
            7: 40,
            8: 13,
            9: 27,
            10: 33,
            11: 34,
            12: 31,
            13: 13,
            14: 40,
            15: 58,
            16: 24,
        },
        47: {
            1: 24,
            2: 17,
            3: 18,
            4: 18,
            5: 21,
            6: 18,
            7: 16,
            8: 24,
            9: 15,
            10: 18,
            11: 33,
            12: 21,
            13: 14,
        },
        48: {
            1: 24,
            2: 21,
            3: 29,
            4: 31,
            5: 26,
            6: 18,
        },
        49: {
            1: 23,
            2: 22,
            3: 21,
            4: 32,
            5: 33,
            6: 24,
        },
        50: {
            1: 30,
            2: 30,
            3: 21,
            4: 23,
        },
        51: {
            1: 29,
            2: 23,
            3: 25,
            4: 18,
        },
        52: {
            1: 10,
            2: 20,
            3: 13,
            4: 18,
            5: 28,
        },
        53: {
            1: 12,
            2: 17,
            3: 18,
        },
        54: {
            1: 20,
            2: 15,
            3: 16,
            4: 16,
            5: 25,
            6: 21,
        },
        55: {
            1: 18,
            2: 26,
            3: 17,
            4: 22,
        },
        56: {
            1: 16,
            2: 15,
            3: 15,
        },
        57: {
            1: 25,
        },
        58: {
            1: 14,
            2: 18,
            3: 19,
            4: 16,
            5: 14,
            6: 20,
            7: 28,
            8: 13,
            9: 28,
            10: 39,
            11: 40,
            12: 29,
            13: 25,
        },
        59: {
            1: 27,
            2: 26,
            3: 18,
            4: 17,
            5: 20,
        },
        60: {
            1: 25,
            2: 25,
            3: 22,
            4: 19,
            5: 14,
        },
        61: {
            1: 21,
            2: 22,
            3: 18,
        },
        62: {
            1: 10,
            2: 29,
            3: 24,
            4: 21,
            5: 21,
        },
        63: {
            1: 13,
        },
        64: {
            1: 14,
        },
        65: {
            1: 25,
        },
        66: {
            1: 20,
            2: 29,
            3: 22,
            4: 11,
            5: 14,
            6: 17,
            7: 17,
            8: 13,
            9: 21,
            10: 11,
            11: 19,
            12: 17,
            13: 18,
            14: 20,
            15: 8,
            16: 21,
            17: 18,
            18: 24,
            19: 21,
            20: 15,
            21: 27,
            22: 21,
        },
    }

    @staticmethod
    def getLastChapter(book):
        if book in BibleBooks.chapters.keys():
            return BibleBooks.chapters[book]
        else:
            return 100

    def getAllKJVreferences(self, lang=None):
        if lang is None:
            lang = config.standardAbbreviation
        standardAbbreviation = self.booksMap.get(lang)
        abbReferences = []
        bcvReferences = []
        separator1 = "_" if config.runMode == "terminal" else " "
        separator2 = "_" if config.runMode == "terminal" else ":"
        separator3 = "_" if config.runMode == "terminal" else "."
        for b, value in self.verses.items():
            for c, v in value.items():
                for i in range(v):
                    abbReferences.append(f"{standardAbbreviation[str(b)][0]}{separator1}{c}{separator2}{(i+1)}")
                    bcvReferences.append(f"{b}{separator3}{c}{separator3}{(i+1)}")
        return (abbReferences, bcvReferences)

    def getStandardBookAbbreviations(self, lang=None):
        if lang is None:
            lang = config.standardAbbreviation
        books = []
        standardAbbreviation = self.booksMap.get(lang)
        if standardAbbreviation:
            for item in standardAbbreviation.keys():
                books.append(standardAbbreviation[item][0])
                if item == "66":
                    break
        return books

    def getStandardBookAbbreviation(self, bookNo, lang=None):
        if lang is None:
            lang = config.standardAbbreviation
        standardAbbreviation = self.booksMap.get(lang)
        if standardAbbreviation:
            return standardAbbreviation.get(str(bookNo), "")[0]
        return ""

    def getStandardBookFullName(self, bookNo, lang=None):
        if lang is None:
            lang = config.standardAbbreviation
        standardAbbreviation = self.booksMap.get(lang)
        if standardAbbreviation:
            return standardAbbreviation.get(str(bookNo), "")[-1]
        return ""

    def __init__(self):
        import re
        if not BibleBooks.initialized:
            languageFolder = os.path.join(PACKAGE_PATH, "plugins", "uba", "lib", "language")
            if os.path.isdir(languageFolder):
                files = glob.glob(os.path.join(languageFolder, "*.biblebooks"))
                for file in files:
                    lang = Path(file).stem
                    abbreviations = {}
                    try:
                        with open(file, "r", encoding="utf-8") as fileObj:
                            for line in fileObj.readlines():
                                if "(" in line:
                                    (number, abbrev, name) = re.search(r'.*"(.*)".*"(.*)".*"(.*)"', line).groups()
                                    abbreviations[number] = (abbrev, name)
                                elif ":" in line:
                                    (abbrev, number) = re.search(r'.*"(.*)".*"(.*)"', line).groups()
                                    BibleBooks.name2number[abbrev] = number
                        if len(abbreviations) > 0:
                            BibleBooks.abbrev[lang] = abbreviations
                    except Exception as ex:
                        print(ex)
            for key in BibleBooks.abbrev.keys():
                BibleBooks.booksMap[key.upper()] = BibleBooks.abbrev[key]
            BibleBooks.initialized = True


if __name__ == '__main__':
    from uniquebible import config
    from uniquebible.util.ConfigUtil import ConfigUtil
    from uniquebible.util.LanguageUtil import LanguageUtil
    import re

    ConfigUtil.setup()
    config.noQt = False
    config.thisTranslation = LanguageUtil.loadTranslation("en_US")

    bibleBooks = BibleBooks()
    print(BibleBooks().booksMap)

    # ot = []
    # nt = []
    # lang = "ENG"
    # for count, item in enumerate(BibleBooks().getStandardBookAbbreviations(lang), 1):
    #     pattern = "<ref.*>{0}.*</ref>".format(item)
    #     if count < 40:
    #         ot.append(pattern)
    #     else:
    #         nt.append(pattern)
    # print("Books - OT:::" + "|".join(ot))
    # print("Books - NT:::" + "|".join(nt))

    # from uniquebible.util.BibleBooks import BibleBooks
    # from uniquebible.db.BiblesSqlite import Bible
    #
    # bible = Bible("KJV")
    # for book in range(1, 67):
    #     print("{0}: {1}".format(book, "{"))
    #     for chapter in range(1, BibleBooks.chapters[book] + 1):
    #         verses = len(bible.getVerseList(book, chapter))
    #         print("{0}: {1},".format(chapter, verses))
    #     print("},")

    # line = "Book G976 [of] birth G1078 [of] jesus G2424 christ G5547 son G5207 {of} david G1138 son G5207 {of} abraham G11"
    # line = re.sub(r" ([EHG][0-9]+?)( |$)", r""" <b>\1</b> """, line)
    # print(line)


